/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tooltips;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.keys.KeyBindings;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TooltipRender {
    private static final int STACKS_PER_LINE = 8;
    public static ITooltipSettings lastUsedTooltipItem = null;

    @SubscribeEvent
    public void onMakeTooltip(ItemTooltipEvent event) {
        ITooltipExtras extras;
        List<Pair<ItemStack, Integer>> items;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ITooltipExtras && !(items = (extras = (ITooltipExtras)stack.func_77973_b()).getItems(stack)).isEmpty()) {
            List tooltip = event.getToolTip();
            int count = items.size();
            int lines = ((count - 1) / 8 + 1) * 2;
            int width = Math.min(8, count) * 18;
            String spaces = "";
            while (mc.field_71466_p.func_78256_a(spaces) < width) {
                spaces = spaces + " ";
            }
            for (int j = 0; j < lines; ++j) {
                tooltip.add(new StringTextComponent(spaces));
            }
        }
    }

    private static ITooltipSettings getSettings(Item item) {
        if (item instanceof ITooltipSettings) {
            return (ITooltipSettings)item;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof ITooltipSettings) {
            return (ITooltipSettings)((BlockItem)item).func_179223_d();
        }
        return null;
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ManualEntry entry;
        ITooltipSettings settings;
        Item item = event.getItemStack().func_77973_b();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null && (entry = settings.getManualEntry()).getManual() != null && KeyBindings.openManual != null && !McJtyLib.proxy.isSneaking()) {
            String translationKey = KeyBindings.openManual.func_197982_m();
            event.getToolTip().add(new StringTextComponent("<Press ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new TranslationTextComponent(translationKey).func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(" for help>").func_240699_a_(TextFormatting.YELLOW)));
        }
    }

    @SubscribeEvent
    public void onTooltipPre(RenderTooltipEvent.Pre event) {
        ITooltipSettings settings;
        Item item = event.getStack().func_77973_b();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null) {
            event.setMaxWidth(Math.max(event.getMaxWidth(), settings.getMaxWidth()));
        }
    }

    @SubscribeEvent
    public void onDrawTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof ITooltipExtras) {
            ITextProperties s;
            ITooltipExtras extras = (ITooltipExtras)stack.func_77973_b();
            List<Pair<ItemStack, Integer>> items = extras.getItems(stack);
            int count = items.size();
            int bx = event.getX();
            int by = event.getY() + 3;
            List tooltip = event.getLines();
            int lines = (count - 1) / 8 + 1;
            int width = Math.min(8, count) * 18;
            int height = lines * 20 + 1;
            Iterator iterator = tooltip.iterator();
            while (iterator.hasNext() && !(s = (ITextProperties)iterator.next()).getString().startsWith("    ")) {
                by += 10;
            }
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            int j = 0;
            for (Pair<ItemStack, Integer> item : items) {
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                TooltipRender.renderBlocks(event.getMatrixStack(), (ItemStack)item.getLeft(), x, y, ((ItemStack)item.getLeft()).func_190916_E(), (Integer)item.getRight());
                ++j;
            }
        }
    }

    private static void renderBlocks(MatrixStack matrixStack, ItemStack itemStack, int x, int y, int count, int errorAmount) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_227731_j_();
        ItemRenderer render = mc.func_175599_af();
        RenderHelper.func_227783_c_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 400.0);
        TooltipRender.renderItemModelIntoGUI(render, matrixStack, itemStack, x, y, render.func_184393_a(itemStack, (World)null, (LivingEntity)null));
        matrixStack.func_227865_b_();
        String s1 = count == Integer.MAX_VALUE ? "\u221e" : Integer.toString((int)((float)count));
        int w1 = mc.field_71466_p.func_78256_a(s1);
        int color = 0xFFFFFF;
        boolean hasReq = true;
        if (errorAmount != -2) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(16 - w1), (double)(hasReq ? 8 : 10), 550.0);
            mc.field_71466_p.func_238405_a_(matrixStack, s1, (float)x, (float)y, color);
            matrixStack.func_227865_b_();
        }
        boolean missingCount = false;
        if (errorAmount >= 0) {
            String fs = Integer.toString(errorAmount);
            String s2 = "(" + fs + ")";
            int w2 = mc.field_71466_p.func_78256_a(s2);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x + 8 - w2 / 4), (double)(y + 17), 550.0);
            mc.field_71466_p.func_238405_a_(matrixStack, s2, 0.0f, 0.0f, -65536);
            matrixStack.func_227865_b_();
        }
        GlStateManager.func_227734_k_();
    }

    private static void renderItemModelIntoGUI(ItemRenderer render, MatrixStack matrixStack, ItemStack itemStack, int x, int y, IBakedModel bakedmodel) {
        boolean flag;
        matrixStack.func_227860_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227861_a_((double)x, (double)y, (double)(100.0f + render.field_77023_b));
        matrixStack.func_227861_a_(8.0, 8.0, 0.0);
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        render.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        matrixStack.func_227865_b_();
    }
}

