/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multiblock;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.IMultiblockFixer;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class MultiblockSupport {
    public static <T extends IMultiblock> void addBlock(World level, BlockPos thisPos, MultiblockDriver<T> driver, T newMb) {
        int mbId;
        BiFunction<World, BlockPos, IMultiblockConnector> holderGetter = driver.getHolderGetter();
        IMultiblockFixer<T> fixer = driver.getFixer();
        HashSet<Integer> adjacentGeneratorIds = new HashSet<Integer>();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos pos = thisPos.func_177972_a(direction);
            IMultiblockConnector holder = holderGetter.apply(level, pos);
            if (holder == null) continue;
            adjacentGeneratorIds.add(holder.getMultiblockId());
        }
        IMultiblockConnector thisHolder = holderGetter.apply(level, thisPos);
        if (adjacentGeneratorIds.isEmpty()) {
            mbId = driver.createId();
            driver.createOrUpdate(mbId, newMb);
            fixer.initialize(driver, level, newMb, mbId);
        } else if (adjacentGeneratorIds.size() == 1) {
            mbId = (Integer)adjacentGeneratorIds.iterator().next();
            fixer.blockAdded(driver, level, thisPos, mbId, newMb);
        } else {
            Set mbs = adjacentGeneratorIds.stream().map(driver::get).collect(Collectors.toSet());
            int masterId = (Integer)adjacentGeneratorIds.iterator().next();
            HashSet done = Sets.newHashSet();
            MultiblockSupport.setBlocksToNetwork(level, thisPos, done, masterId, driver);
            mbs.add(newMb);
            fixer.merge(driver, level, mbs, masterId);
        }
    }

    private static <T extends IMultiblock> void setBlocksToNetwork(World level, BlockPos c, Set<BlockPos> done, int newId, MultiblockDriver<T> driver) {
        IMultiblockConnector connector = driver.getHolderGetter().apply(level, c);
        if (connector == null) {
            return;
        }
        done.add(c);
        connector.setMultiblockId(newId);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos newC = c.func_177972_a(direction);
            if (done.contains(newC) || driver.getHolderGetter().apply(level, newC) == null) continue;
            MultiblockSupport.setBlocksToNetwork(level, newC, done, newId, driver);
        }
    }

    public static <T extends IMultiblock> void removeBlock(World level, BlockPos thisPos, MultiblockDriver<T> driver) {
        BiFunction<World, BlockPos, IMultiblockConnector> holderGetter = driver.getHolderGetter();
        IMultiblockConnector thisHolder = holderGetter.apply(level, thisPos);
        T thisData = driver.get(thisHolder.getMultiblockId());
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos newC = thisPos.func_177972_a(direction);
            IMultiblockConnector holder = holderGetter.apply(level, newC);
            if (holder == null) continue;
            HashSet done = Sets.newHashSet();
            done.add(thisPos);
            MultiblockSupport.setBlocksToNetwork(level, newC, done, -1, driver);
        }
        ArrayList<Pair<Integer, Set<BlockPos>>> todo = new ArrayList<Pair<Integer, Set<BlockPos>>>();
        int idToUse = thisHolder.getMultiblockId();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos newC = thisPos.func_177972_a(direction);
            IMultiblockConnector holder = holderGetter.apply(level, newC);
            if (holder == null || holder.getMultiblockId() != -1) continue;
            if (idToUse == -1) {
                idToUse = driver.createId();
            }
            HashSet done = Sets.newHashSet();
            done.add(thisPos);
            MultiblockSupport.setBlocksToNetwork(level, newC, done, idToUse, driver);
            T mb = driver.get(idToUse);
            todo.add((Pair<Integer, Set<BlockPos>>)Pair.of((Object)idToUse, (Object)done));
            idToUse = -1;
        }
        driver.getFixer().distribute(driver, level, thisData, todo);
    }
}

