/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.CopyBlockState;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    protected final Map<EntityType<?>, LootTable.Builder> entityLootTables = new HashMap();
    protected final Map<ResourceLocation, LootTable.Builder> chestLootTables = new HashMap<ResourceLocation, LootTable.Builder>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected void addItemDropTable(EntityType<?> entityType, IItemProvider item) {
        this.entityLootTables.put(entityType, this.createItemDropTable(entityType.getRegistryName().func_110623_a(), item));
    }

    protected void addChestLootTable(ResourceLocation id, LootTable.Builder builder) {
        this.chestLootTables.put(id, builder);
    }

    protected void addItemDropTable(EntityType<?> entityType, IItemProvider item, float min, float max, float lmin, float lmax) {
        this.entityLootTables.put(entityType, this.createItemDropTable(entityType.getRegistryName().func_110623_a(), item, min, max, lmin, lmax));
    }

    protected LootTable.Builder createItemDropTable(String name, IItemProvider item) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createItemDropTable(String name, IItemProvider item, float min, float max, float lmin, float lmax) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)lmin, (float)lmax))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSilkTouchTable(String name, Block block, Item lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))), ItemLootEntry.func_216168_a((IItemProvider)lootItem).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(min, max))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)1)).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b())}));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected void addBlockStateTable(Block block, Property property) {
        this.lootTables.put(block, this.createBlockStateTable(block.getRegistryName().func_110623_a(), block, property));
    }

    protected LootTable.Builder createBlockStateTable(String name, Block block, Property property) {
        LootPool.Builder builder = LootPool.func_216096_a().name(block.getRegistryName().func_110623_a()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)block).func_227552_a_(property)));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected void addStandardTable(Block block) {
        this.lootTables.put(block, this.createStandardTable(block.getRegistryName().func_110623_a(), block));
    }

    protected LootTable.Builder createStandardTable(String name, Block block) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216055_a("Info", "BlockEntityTag.Info", CopyNbt.Action.REPLACE).func_216055_a("Items", "BlockEntityTag.Items", CopyNbt.Action.REPLACE).func_216055_a("Energy", "BlockEntityTag.Energy", CopyNbt.Action.REPLACE)).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected void addSimpleTable(Block block) {
        this.lootTables.put(block, this.createSimpleTable(block.getRegistryName().func_110623_a(), block));
    }

    protected LootTable.Builder createSimpleTable(String name, Block block) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSimpleTable(String name, Item item) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        for (Map.Entry<Block, LootTable.Builder> entry : this.entityLootTables.entrySet()) {
            tables.put(((EntityType)entry.getKey()).func_220348_g(), entry.getValue().func_216039_a(LootParameterSets.field_216263_d).func_216038_b());
        }
        for (Map.Entry<Block, LootTable.Builder> entry : this.chestLootTables.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            tables.put(id, entry.getValue().func_216039_a(LootParameterSets.field_216261_b).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
                throw new RuntimeException(e);
            }
        });
    }
}

