/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Objects;
import java.util.function.Predicate;
import mcjty.lib.container.SlotType;
import mcjty.lib.varia.TriConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class SlotDefinition {
    private final SlotType type;
    private boolean input = false;
    private boolean output = false;
    private final Predicate<ItemStack> validItems;
    private TriConsumer<TileEntity, PlayerEntity, ItemStack> onCraft;

    SlotDefinition(SlotType type, ItemStack ... itemStacks) {
        this.onCraft = (te, playerEntity, stack) -> {};
        this.type = type;
        this.validItems = stack -> {
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.func_77973_b() != stack.func_77973_b()) continue;
                return true;
            }
            return false;
        };
    }

    public SlotDefinition onCraft(TriConsumer<TileEntity, PlayerEntity, ItemStack> onCraft) {
        this.onCraft = onCraft;
        return this;
    }

    public SlotDefinition in() {
        this.input = true;
        return this;
    }

    public SlotDefinition out() {
        this.output = true;
        return this;
    }

    public TriConsumer<TileEntity, PlayerEntity, ItemStack> getOnCraft() {
        return this.onCraft;
    }

    private SlotDefinition(SlotType type, Predicate<ItemStack> validItems) {
        this.onCraft = (te, playerEntity, stack) -> {};
        this.type = type;
        this.validItems = validItems;
    }

    public static SlotDefinition specific(ItemStack ... stacks) {
        return new SlotDefinition(SlotType.SLOT_SPECIFICITEM, stacks);
    }

    public static SlotDefinition specific(Predicate<ItemStack> validItems) {
        return new SlotDefinition(SlotType.SLOT_SPECIFICITEM, validItems);
    }

    public static SlotDefinition generic() {
        return new SlotDefinition(SlotType.SLOT_GENERIC, new ItemStack[0]);
    }

    public static SlotDefinition ghost() {
        return new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]);
    }

    public static SlotDefinition ghostOut() {
        return new SlotDefinition(SlotType.SLOT_GHOSTOUT, new ItemStack[0]);
    }

    public static SlotDefinition craftResult() {
        return new SlotDefinition(SlotType.SLOT_CRAFTRESULT, new ItemStack[0]);
    }

    public SlotType getType() {
        return this.type;
    }

    public boolean itemStackMatches(ItemStack stack) {
        return this.validItems.test(stack);
    }

    public boolean isSpecific() {
        return this.type == SlotType.SLOT_SPECIFICITEM;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean isOutput() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotDefinition that = (SlotDefinition)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }
}

