/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.vector.Matrix4f;

public class QuadTransformer {
    private static void processVertices(Matrix4f transform, VertexFormat fmt, int positionIndex, int[] inData, int[] outData) {
        int positionOffset = fmt.getOffset(positionIndex);
        int stride = fmt.func_177338_f() / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = positionOffset + i * stride;
            float x = Float.intBitsToFloat(inData[offset]);
            float y = Float.intBitsToFloat(inData[offset + 1]);
            float f = Float.intBitsToFloat(inData[offset + 2]);
        }
    }

    private static int findPositionIndex(VertexFormat fmt) {
        int positionIndex;
        VertexFormatElement positionElement = null;
        ImmutableList list = fmt.func_227894_c_().asList();
        for (positionIndex = 0; positionIndex < list.size(); ++positionIndex) {
            VertexFormatElement el = (VertexFormatElement)list.get(positionIndex);
            if (el.func_177375_c() != VertexFormatElement.Usage.POSITION) continue;
            positionElement = el;
            break;
        }
        if (positionIndex == list.size() || positionElement == null) {
            throw new RuntimeException("WAT? Position not found");
        }
        if (positionElement.func_177367_b() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("WAT? Position not FLOAT");
        }
        if (positionElement.func_177368_f() < 3) {
            throw new RuntimeException("WAT? Position not 3D");
        }
        return positionIndex;
    }

    public static BakedQuad processOne(BakedQuad input, Matrix4f transform) {
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        int[] data = input.func_178209_a();
        QuadTransformer.processVertices(transform, fmt, positionIndex, data, data);
        return new BakedQuad(data, input.func_178211_c(), input.func_178210_d(), input.func_187508_a(), input.func_239287_f_());
    }

    public static List<BakedQuad> processMany(List<BakedQuad> inputs, Matrix4f transform) {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        ArrayList outputs = Lists.newArrayList();
        for (BakedQuad input : inputs) {
            int[] inData = input.func_178209_a();
            int[] outData = Arrays.copyOf(inData, inData.length);
            QuadTransformer.processVertices(transform, fmt, positionIndex, inData, outData);
            outputs.add(new BakedQuad(outData, input.func_178211_c(), input.func_178210_d(), input.func_187508_a(), input.func_239287_f_()));
        }
        return outputs;
    }

    public static void processManyInPlace(List<BakedQuad> inputs, Matrix4f transform) {
        if (inputs.size() == 0) {
            return;
        }
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        for (BakedQuad input : inputs) {
            int[] data = input.func_178209_a();
            QuadTransformer.processVertices(transform, fmt, positionIndex, data, data);
        }
    }
}

