/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.WorldTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class GuiTools {
    public static int getRelativeX(Screen gui) {
        Minecraft mc = Minecraft.func_71410_x();
        int mainWidth = mc.func_228018_at_().func_198105_m();
        if (mainWidth <= 0) {
            return 0;
        }
        MouseHelper mouse = mc.field_71417_B;
        int mouseX = (int)mouse.func_198024_e();
        return mouseX * gui.field_230708_k_ / mainWidth;
    }

    public static int getRelativeY(Screen gui) {
        Minecraft mc = Minecraft.func_71410_x();
        int mainHeight = mc.func_228018_at_().func_198083_n();
        if (mainHeight <= 0) {
            return 0;
        }
        MouseHelper mouse = mc.field_71417_B;
        int mouseY = (int)mouse.func_198026_f();
        return mouseY * gui.field_230709_l_ / mainHeight;
    }

    public static boolean openRemoteGui(@Nonnull PlayerEntity player, @Nullable DimensionId dimensionType, @Nonnull BlockPos pos) {
        return GuiTools.openRemoteGui(player, dimensionType, pos, te -> new INamedContainerProvider((TileEntity)te){
            final /* synthetic */ TileEntity val$te;
            {
                this.val$te = tileEntity;
            }

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Remote Gui");
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                return this.val$te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> h.createMenu(id, inventory, player)).orElse(null);
            }
        });
    }

    public static boolean openRemoteGui(@Nonnull PlayerEntity player, @Nullable DimensionId dimensionType, @Nonnull BlockPos pos, Function<TileEntity, INamedContainerProvider> provider) {
        ServerWorld world;
        if (dimensionType == null) {
            dimensionType = DimensionId.fromWorld(player.func_130014_f_());
        }
        if (!WorldTools.isLoaded((World)(world = WorldTools.getWorld(player.func_130014_f_(), dimensionType)), pos)) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Position is not loaded!"), false);
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Tile entity is missing!"), false);
            return false;
        }
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT written = te.func_189515_b(compound);
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider.apply(te), arg_0 -> GuiTools.lambda$openRemoteGui$1(pos, (World)world, written, arg_0));
        return true;
    }

    private static /* synthetic */ void lambda$openRemoteGui$1(BlockPos pos, World world, CompoundNBT written, PacketBuffer buf) {
        buf.func_179255_a(pos);
        DimensionId.fromWorld(world).toBytes(buf);
        buf.func_150786_a(written);
    }
}

