/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.builder;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.builder.InfoLine;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TooltipBuilder {
    private InfoLine[] infoLines;
    private InfoLine[] shiftInfoLines;
    private InfoLine[] advancedInfoLines;

    public TooltipBuilder info(InfoLine ... lines) {
        this.infoLines = lines;
        return this;
    }

    public TooltipBuilder infoShift(InfoLine ... lines) {
        this.shiftInfoLines = lines;
        return this;
    }

    public TooltipBuilder infoAdvanced(InfoLine ... lines) {
        this.advancedInfoLines = lines;
        return this;
    }

    private static TranslationTextComponent stylize(String translationKey, TextFormatting ... formattings) {
        TranslationTextComponent component = new TranslationTextComponent(translationKey);
        for (TextFormatting format : formattings) {
            component.func_240699_a_(format);
        }
        return component;
    }

    public void makeTooltip(@Nonnull ResourceLocation id, @Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, ITooltipFlag flag) {
        String namespace = id.func_110624_b();
        String path = id.func_110623_a();
        String prefix = "message." + namespace + "." + path + ".";
        InfoLine[] lines = this.infoLines;
        if (this.infoLines == null || McJtyLib.proxy.isSneaking() && this.shiftInfoLines != null) {
            lines = this.shiftInfoLines;
        }
        this.addLines(stack, tooltip, prefix, lines);
        if (this.advancedInfoLines != null && flag.func_194127_a()) {
            this.addLines(stack, tooltip, prefix, this.advancedInfoLines);
        }
    }

    private void addLines(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, String prefix, InfoLine[] lines) {
        for (InfoLine line : lines) {
            if (!line.getCondition().test(stack)) continue;
            if (line.getRepeatingParameter() != null) {
                line.getRepeatingParameter().apply(stack).forEach(s -> {
                    TranslationTextComponent component = line.getTranslationKey() != null ? TooltipBuilder.stylize(line.getTranslationKey(), line.getStyles()) : TooltipBuilder.stylize(prefix + line.getSuffix(), line.getStyles());
                    ((IFormattableTextComponent)component).func_230529_a_((ITextComponent)new StringTextComponent(TextFormatting.WHITE + s));
                    tooltip.add((ITextComponent)component);
                });
                continue;
            }
            TranslationTextComponent component = line.getTranslationKey() != null ? TooltipBuilder.stylize(line.getTranslationKey(), line.getStyles()) : TooltipBuilder.stylize(prefix + line.getSuffix(), line.getStyles());
            if (line.getInformationGetter() != null) {
                String extra = line.getInformationGetter().apply(stack);
                if (extra == null) continue;
                ((IFormattableTextComponent)component).func_230529_a_((ITextComponent)new StringTextComponent(TextFormatting.WHITE + extra));
                tooltip.add((ITextComponent)component);
                continue;
            }
            tooltip.add((ITextComponent)component);
        }
    }

    public boolean isActive() {
        return this.infoLines != null || this.shiftInfoLines != null;
    }

    public static InfoLine key(String key) {
        return new InfoLine(key, null, stack -> true, null, null, TextFormatting.YELLOW);
    }

    public static InfoLine header() {
        return new InfoLine(null, "header", stack -> true, null, null, TextFormatting.GREEN);
    }

    public static InfoLine warning(Predicate<ItemStack> condition) {
        return new InfoLine(null, "warning", condition, null, null, TextFormatting.RED);
    }

    public static InfoLine warning() {
        return new InfoLine(null, "warning", stack -> true, null, null, TextFormatting.RED);
    }

    public static InfoLine gold(Predicate<ItemStack> condition) {
        return new InfoLine(null, "gold", condition, null, null, TextFormatting.GOLD);
    }

    public static InfoLine gold() {
        return new InfoLine(null, "gold", stack -> true, null, null, TextFormatting.GOLD);
    }

    public static InfoLine general(String suffix, TextFormatting ... styles) {
        return new InfoLine(null, suffix, stack -> true, null, null, styles);
    }

    public static InfoLine general(String suffix, Predicate<ItemStack> condition, TextFormatting ... styles) {
        return new InfoLine(null, suffix, condition, null, null, styles);
    }

    public static InfoLine parameter(String suffix, Function<ItemStack, String> getter) {
        return new InfoLine(null, suffix, stack -> true, getter, null, TextFormatting.GRAY, TextFormatting.BOLD);
    }

    public static InfoLine parameter(String suffix, Predicate<ItemStack> condition, Function<ItemStack, String> getter) {
        return new InfoLine(null, suffix, condition, getter, null, TextFormatting.GRAY, TextFormatting.BOLD);
    }

    public static InfoLine repeatingParameter(String suffix, Function<ItemStack, Stream<String>> repeater) {
        return new InfoLine(null, suffix, stack -> true, null, repeater, TextFormatting.GRAY, TextFormatting.BOLD);
    }
}

