/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.setup;

import com.refinedmods.refinedpipes.RefinedPipesBlocks;
import com.refinedmods.refinedpipes.RefinedPipesContainers;
import com.refinedmods.refinedpipes.RefinedPipesTileEntities;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentRegistry;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeType;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeType;
import com.refinedmods.refinedpipes.render.FluidPipeTileEntityRenderer;
import com.refinedmods.refinedpipes.render.ItemPipeTileEntityRenderer;
import com.refinedmods.refinedpipes.render.PipeBakedModel;
import com.refinedmods.refinedpipes.screen.ExtractorAttachmentScreen;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientSetup {
    private static final Logger LOGGER = LogManager.getLogger(ClientSetup.class);

    public ClientSetup() {
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            LOGGER.debug("Registering attachment model {}", (Object)factory.getModelLocation());
            ModelLoader.addSpecialModel((ResourceLocation)factory.getModelLocation());
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
        for (String type : new String[]{"item", "fluid", "energy"}) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/basic/core"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/basic/extension"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/basic/straight"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/improved/core"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/improved/extension"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/improved/straight"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/advanced/core"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/advanced/extension"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/advanced/straight"));
            if (!type.equals("fluid") && !type.equals("energy")) continue;
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/elite/core"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/elite/extension"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/elite/straight"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/ultimate/core"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/ultimate/extension"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/" + type + "/ultimate/straight"));
        }
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment"));
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(RefinedPipesContainers.EXTRACTOR_ATTACHMENT, ExtractorAttachmentScreen::new);
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.BASIC_ITEM_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.IMPROVED_ITEM_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.ADVANCED_ITEM_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.BASIC_FLUID_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.IMPROVED_FLUID_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.ADVANCED_FLUID_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.ELITE_FLUID_PIPE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RefinedPipesBlocks.ULTIMATE_FLUID_PIPE, (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.BASIC_ITEM_PIPE, ItemPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.IMPROVED_ITEM_PIPE, ItemPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.ADVANCED_ITEM_PIPE, ItemPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.BASIC_FLUID_PIPE, FluidPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.IMPROVED_FLUID_PIPE, FluidPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.ADVANCED_FLUID_PIPE, FluidPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.ELITE_FLUID_PIPE, FluidPipeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RefinedPipesTileEntities.ULTIMATE_FLUID_PIPE, FluidPipeTileEntityRenderer::new);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        HashMap<ResourceLocation, IBakedModel> attachmentModels = new HashMap<ResourceLocation, IBakedModel>();
        for (AttachmentFactory factory : AttachmentRegistry.INSTANCE.all()) {
            attachmentModels.put(factory.getId(), (IBakedModel)e.getModelRegistry().get(factory.getModelLocation()));
        }
        HashMap<ResourceLocation, PipeBakedModel> pipeModels = new HashMap<ResourceLocation, PipeBakedModel>();
        pipeModels.put(ItemPipeType.BASIC.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/basic/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/basic/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/basic/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(ItemPipeType.IMPROVED.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/improved/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/improved/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/improved/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(ItemPipeType.ADVANCED.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/advanced/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/advanced/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/item/advanced/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.BASIC.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/basic/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/basic/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/basic/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.IMPROVED.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/improved/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/improved/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/improved/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.ADVANCED.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/advanced/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/advanced/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/advanced/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.ELITE.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/elite/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/elite/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/elite/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(FluidPipeType.ULTIMATE.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/ultimate/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/ultimate/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/fluid/ultimate/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.BASIC.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/basic/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/basic/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/basic/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.IMPROVED.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/improved/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/improved/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/improved/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.ADVANCED.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/advanced/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/advanced/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/advanced/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.ELITE.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/elite/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/elite/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/elite/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        pipeModels.put(EnergyPipeType.ULTIMATE.getId(), new PipeBakedModel((IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/ultimate/core")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/ultimate/extension")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/energy/ultimate/straight")), (IBakedModel)e.getModelRegistry().get(new ResourceLocation("refinedpipes:block/pipe/attachment/inventory_attachment")), attachmentModels));
        block1: for (ResourceLocation id : e.getModelRegistry().keySet()) {
            for (Map.Entry entry : pipeModels.entrySet()) {
                if (!this.isPipeModel(id, (ResourceLocation)entry.getKey())) continue;
                e.getModelRegistry().put(id, entry.getValue());
                continue block1;
            }
        }
    }

    private boolean isPipeModel(ResourceLocation modelId, ResourceLocation pipeId) {
        return modelId instanceof ModelResourceLocation && modelId.func_110624_b().equals("refinedpipes") && modelId.func_110623_a().equals(pipeId.func_110623_a()) && !((ModelResourceLocation)modelId).func_177518_c().equals("inventory");
    }
}

