/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.google.common.collect.ImmutableList;
import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.render.PipeState;
import com.refinedmods.refinedpipes.tile.PipeTileEntity;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public class PipeBakedModel
implements IBakedModel {
    private static final Map<Direction, TransformationMatrix> SIDE_TRANSFORMS = new EnumMap<Direction, TransformationMatrix>(Direction.class);
    private final IBakedModel core;
    private final IBakedModel extension;
    private final IBakedModel straight;
    private final IBakedModel inventoryAttachment;
    private final Map<ResourceLocation, IBakedModel> attachmentModels;
    private final Map<PipeState, List<BakedQuad>> cache = new HashMap<PipeState, List<BakedQuad>>();

    public PipeBakedModel(IBakedModel core, IBakedModel extension, IBakedModel straight, IBakedModel inventoryAttachment, Map<ResourceLocation, IBakedModel> attachmentModels) {
        this.core = core;
        this.extension = extension;
        this.straight = straight;
        this.inventoryAttachment = inventoryAttachment;
        this.attachmentModels = attachmentModels;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        PipeState pipeState = new PipeState(state, (ResourceLocation[])extraData.getData(PipeTileEntity.ATTACHMENTS_PROPERTY), side, rand);
        return this.cache.computeIfAbsent(pipeState, this::createQuads);
    }

    private List<BakedQuad> createQuads(PipeState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state.getState() != null) {
            boolean north = (Boolean)state.getState().func_177229_b((Property)PipeBlock.NORTH);
            int east = ((Boolean)state.getState().func_177229_b((Property)PipeBlock.EAST)).booleanValue() ? 1 : 0;
            int south = ((Boolean)state.getState().func_177229_b((Property)PipeBlock.SOUTH)).booleanValue() ? 1 : 0;
            boolean west = (Boolean)state.getState().func_177229_b((Property)PipeBlock.WEST);
            boolean up = (Boolean)state.getState().func_177229_b((Property)PipeBlock.UP);
            boolean down = (Boolean)state.getState().func_177229_b((Property)PipeBlock.DOWN);
            if (north && south != 0 && east == 0 && !west && !up && !down) {
                quads.addAll(this.straight.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else if (!north && south == 0 && east != 0 && west && !up && !down) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.straight, Direction.EAST, state));
            } else if (!north && south == 0 && east == 0 && !west && up && down) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.straight, Direction.UP, state));
            } else if (!(north || south != 0 || east != 0 || west || up || down)) {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                if (north) {
                    quads.addAll(this.extension.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (east != 0) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.EAST, state));
                }
                if (south != 0) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.SOUTH, state));
                }
                if (west) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.WEST, state));
                }
                if (up) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.UP, state));
                }
                if (down) {
                    quads.addAll(PipeBakedModel.getTransformedQuads(this.extension, Direction.DOWN, state));
                }
            }
        }
        if (state.getAttachmentState() != null) {
            for (Direction dir : Direction.values()) {
                ResourceLocation attachmentId = state.getAttachmentState()[dir.ordinal()];
                if (attachmentId == null) continue;
                quads.addAll(PipeBakedModel.getTransformedQuads(this.attachmentModels.get(attachmentId), dir, state));
            }
        }
        if (state.getState() != null) {
            boolean invNorth = (Boolean)state.getState().func_177229_b((Property)PipeBlock.INV_NORTH);
            boolean invEast = (Boolean)state.getState().func_177229_b((Property)PipeBlock.INV_EAST);
            boolean invSouth = (Boolean)state.getState().func_177229_b((Property)PipeBlock.INV_SOUTH);
            boolean invWest = (Boolean)state.getState().func_177229_b((Property)PipeBlock.INV_WEST);
            boolean invUp = (Boolean)state.getState().func_177229_b((Property)PipeBlock.INV_UP);
            boolean invDown = (Boolean)state.getState().func_177229_b((Property)PipeBlock.INV_DOWN);
            if (invNorth && !state.hasAttachmentState(Direction.NORTH)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.NORTH, state));
            }
            if (invEast && !state.hasAttachmentState(Direction.EAST)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.EAST, state));
            }
            if (invSouth && !state.hasAttachmentState(Direction.SOUTH)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.SOUTH, state));
            }
            if (invWest && !state.hasAttachmentState(Direction.WEST)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.WEST, state));
            }
            if (invUp && !state.hasAttachmentState(Direction.UP)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.UP, state));
            }
            if (invDown && !state.hasAttachmentState(Direction.DOWN)) {
                quads.addAll(PipeBakedModel.getTransformedQuads(this.inventoryAttachment, Direction.DOWN, state));
            }
        }
        return quads;
    }

    private static List<BakedQuad> getTransformedQuads(IBakedModel model, Direction facing, PipeState state) {
        TransformationMatrix transformation = SIDE_TRANSFORMS.computeIfAbsent(facing, face -> {
            Quaternion quaternion;
            if (face == Direction.UP) {
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(90.0f, 0.0f, 0.0f), (boolean)true);
            } else if (face == Direction.DOWN) {
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(270.0f, 0.0f, 0.0f), (boolean)true);
            } else {
                double r = Math.PI * (double)(360 - face.func_176734_d().func_176736_b() * 90) / 180.0;
                quaternion = TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)r, 0.0f), (boolean)false);
            }
            return new TransformationMatrix(null, quaternion, null, null).blockCenterToCorner();
        });
        ImmutableList.Builder quads = ImmutableList.builder();
        Direction side = state.getSide();
        if (side != null && side.func_176736_b() > -1) {
            int faceOffset = 4 + Direction.NORTH.func_176736_b() - facing.func_176736_b();
            side = Direction.func_176731_b((int)((side.func_176736_b() + faceOffset) % 4));
        }
        for (BakedQuad quad : model.getQuads(state.getState(), side, state.getRand(), (IModelData)EmptyModelData.INSTANCE)) {
            BakedQuadBuilder builder = new BakedQuadBuilder(quad.func_187508_a());
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, transformation);
            quad.pipe((IVertexConsumer)transformer);
            quads.add((Object)builder.build());
        }
        return quads.build();
    }

    public boolean func_177555_b() {
        return this.core.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.core.func_177556_c();
    }

    public boolean func_230044_c_() {
        return true;
    }

    public boolean func_188618_c() {
        return this.core.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.core.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.core.func_188617_f();
    }
}

