/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderer {
    public static final FluidRenderer INSTANCE = new FluidRenderer(1000, 16, 16, 16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int capacityMb;
    private final int width;
    private final int height;
    private final int minHeight;

    public FluidRenderer(int capacityMb, int width, int height, int minHeight) {
        this.capacityMb = capacityMb;
        this.width = width;
        this.height = height;
        this.minHeight = minHeight;
    }

    public void render(int xPosition, int yPosition, @Nonnull FluidStack fluidStack) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.drawFluid(xPosition, yPosition, fluidStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private void drawFluid(int xPosition, int yPosition, @Nonnull FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite fluidStillSprite = FluidRenderer.getStillFluidSprite(fluidStack);
        FluidAttributes attributes = fluid.getAttributes();
        int fluidColor = attributes.getColor(fluidStack);
        int amount = fluidStack.getAmount();
        int scaledAmount = amount * this.height / this.capacityMb;
        if (amount > 0 && scaledAmount < this.minHeight) {
            scaledAmount = this.minHeight;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        this.drawTiledSprite(xPosition, yPosition, this.width, this.height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        FluidRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidRenderer.drawTextureWithMasking(x, y, sprite, maskTop, maskRight, 100.0);
            }
        }
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_(xCoord, yCoord + 16.0, zLevel).func_225583_a_((float)uMin, (float)vMax).func_181675_d();
        bufferBuilder.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_225583_a_((float)uMax, (float)vMax).func_181675_d();
        bufferBuilder.func_225582_a_(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_225583_a_((float)uMax, (float)vMin).func_181675_d();
        bufferBuilder.func_225582_a_(xCoord, yCoord + (double)maskTop, zLevel).func_225583_a_((float)uMin, (float)vMin).func_181675_d();
        tessellator.func_78381_a();
    }
}

