/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.part;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.block.BlockCapabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integratedcrafting.Capabilities;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingInterface;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.capability.network.CraftingInterfaceConfig;
import org.cyclops.integratedcrafting.capability.network.CraftingNetworkConfig;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.CraftingJobHandler;
import org.cyclops.integratedcrafting.core.CraftingProcessOverrides;
import org.cyclops.integratedcrafting.core.part.PartTypeCraftingBase;
import org.cyclops.integratedcrafting.ingredient.storage.IngredientComponentStorageSlottedInsertProxy;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCrafting;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integratedcrafting.part.PartTypes;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;
import org.cyclops.integrateddynamics.capability.network.PositionedAddonsNetworkIngredientsHandlerConfig;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;

public class PartTypeInterfaceCrafting
extends PartTypeCraftingBase<PartTypeInterfaceCrafting, State> {
    public PartTypeInterfaceCrafting(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return state.getCraftingJobHandler().getProcessingCraftingJobs().size() * GeneralConfig.interfaceCraftingBaseConsumption;
    }

    @Override
    public Optional<INamedContainerProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new INamedContainerProvider(){

            public IFormattableTextComponent getDisplayName() {
                return new TranslationTextComponent(PartTypeInterfaceCrafting.this.getTranslationKey());
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                State partState = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                return new ContainerPartInterfaceCrafting(id, playerInventory, (IInventory)partState.getInventoryVariables(), Optional.of(data.getRight()), Optional.of(data.getLeft()), (PartTypeInterfaceCrafting)((Object)data.getMiddle()));
            }
        });
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((PartPos)pos);
        State partState = (State)partContainer.getPartState(pos.getSide());
        packetBuffer.writeInt(partState.getInventoryVariables().func_70302_i_());
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    public Optional<INamedContainerProvider> getContainerProviderSettings(final PartPos pos) {
        return Optional.of(new INamedContainerProvider(){

            public IFormattableTextComponent getDisplayName() {
                return new TranslationTextComponent(PartTypeInterfaceCrafting.this.getTranslationKey());
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerPartInterfaceCraftingSettings(id, playerInventory, (IInventory)new Inventory(0), (PartTarget)data.getRight(), Optional.of(data.getLeft()), (IPartType)data.getMiddle());
            }
        });
    }

    protected State constructDefaultState() {
        return new State();
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.afterNetworkReAlive(network, partNetwork, target, (IPartState)state);
        this.addTargetToNetwork(network, target, state);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkRemoval(network, partNetwork, target, (IPartState)state);
        this.removeTargetFromNetwork(network, target.getTarget(), state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkAddition(network, partNetwork, target, (IPartState)state);
        this.addTargetToNetwork(network, target, state);
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), state);
        super.setPriorityAndChannel(network, partNetwork, target, (IPartState)state, priority, channel);
        this.addTargetToNetwork(network, target, state);
    }

    protected Capability<ICraftingNetwork> getNetworkCapability() {
        return CraftingNetworkConfig.CAPABILITY;
    }

    protected void addTargetToNetwork(INetwork network, PartTarget pos, State state) {
        network.getCapability(this.getNetworkCapability()).ifPresent(craftingNetwork -> {
            int channelCrafting = state.getChannelCrafting();
            state.setTarget(pos);
            state.setNetworks(network, (ICraftingNetwork)craftingNetwork, NetworkHelpers.getPartNetworkChecked((INetwork)network), channelCrafting);
            state.setShouldAddToCraftingNetwork(true);
        });
    }

    protected void removeTargetFromNetwork(INetwork network, PartPos pos, State state) {
        ICraftingNetwork craftingNetwork = state.getCraftingNetwork();
        if (craftingNetwork != null) {
            network.getCapability(this.getNetworkCapability()).ifPresent(n -> n.removeCraftingInterface(state.getChannelCrafting(), state));
        }
        state.setNetworks(null, null, null, -1);
        state.setTarget(null);
    }

    public boolean isUpdate(State state) {
        return true;
    }

    public int getMinimumUpdateInterval(State state) {
        return state.getDefaultUpdateInterval();
    }

    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        IntSet slots;
        super.update(network, partNetwork, target, (IPartState)state);
        if (state.getCraftingNetwork() == null) {
            this.addTargetToNetwork(network, target, state);
        }
        int channel = state.getChannelCrafting();
        if (state.shouldAddToCraftingNetwork()) {
            ICraftingNetwork craftingNetwork = (ICraftingNetwork)network.getCapability(this.getNetworkCapability()).orElse(null);
            craftingNetwork.addCraftingInterface(channel, state);
            state.setShouldAddToCraftingNetwork(false);
        }
        ListIterator<IngredientInstanceWrapper<?, ?>> outputBufferIt = state.getInventoryOutputBuffer().listIterator();
        while (outputBufferIt.hasNext()) {
            IngredientInstanceWrapper<?, ?> newWrapper = PartTypeInterfaceCrafting.insertIntoNetwork(outputBufferIt.next(), network, state.getChannelCrafting());
            if (newWrapper == null) {
                outputBufferIt.remove();
                continue;
            }
            outputBufferIt.set(newWrapper);
        }
        if (state.getInventoryOutputBuffer().isEmpty()) {
            PartPos targetPos = state.getTarget().getTarget();
            state.getCraftingJobHandler().update(network, channel, targetPos);
        }
        if (!(slots = state.getDelayedRecipeReloads()).isEmpty()) {
            ICraftingNetwork craftingNetwork = (ICraftingNetwork)network.getCapability(this.getNetworkCapability()).orElse(null);
            if (craftingNetwork != null) {
                for (Integer slot : slots) {
                    Int2ObjectMap<IRecipeDefinition> recipes = state.getRecipesIndexed();
                    IRecipeDefinition oldRecipe = (IRecipeDefinition)recipes.get((Object)slot);
                    if (oldRecipe != null) {
                        craftingNetwork.removeCraftingInterfaceRecipe(channel, state, oldRecipe);
                    }
                    state.reloadRecipe(slot);
                    IRecipeDefinition newRecipe = (IRecipeDefinition)recipes.get((Object)slot);
                    if (newRecipe == null) continue;
                    craftingNetwork.addCraftingInterfaceRecipe(channel, state, newRecipe);
                }
            }
            slots.clear();
        }
    }

    @Nullable
    protected static <T, M> IngredientInstanceWrapper<T, M> insertIntoNetwork(IngredientInstanceWrapper<T, M> wrapper, INetwork network, int channel) {
        IPositionedAddonsNetworkIngredients storageNetwork = wrapper.getComponent().getCapability(PositionedAddonsNetworkIngredientsHandlerConfig.CAPABILITY).map(n -> (IPositionedAddonsNetworkIngredients)n.getStorage(network).orElse(null)).orElse(null);
        if (storageNetwork != null) {
            IIngredientComponentStorage storage = storageNetwork.getChannel(channel);
            Object remaining = storage.insert(wrapper.getInstance(), false);
            if (wrapper.getComponent().getMatcher().isEmpty(remaining)) {
                return null;
            }
            return new IngredientInstanceWrapper(wrapper.getComponent(), remaining);
        }
        return wrapper;
    }

    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (IngredientInstanceWrapper<?, ?> ingredientInstanceWrapper : state.getInventoryOutputBuffer()) {
            if (ingredientInstanceWrapper.getComponent() != IngredientComponent.ITEMSTACK) continue;
            itemStacks.add((ItemStack)ingredientInstanceWrapper.getInstance());
        }
        state.getInventoryOutputBuffer().clear();
        for (int i = 0; i < state.getInventoryVariables().func_70302_i_(); ++i) {
            ItemStack itemStack = state.getInventoryVariables().func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            itemStacks.add(itemStack);
        }
        state.getInventoryVariables().func_174888_l();
        super.addDrops(target, (IPartState)state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartStateBase<PartTypeInterfaceCrafting>
    implements ICraftingInterface,
    ICraftingResultsSink {
        private final CraftingJobHandler craftingJobHandler = new CraftingJobHandler(1, CraftingProcessOverrides.REGISTRY.getCraftingProcessOverrides(), this);
        private final SimpleInventory inventoryVariables = new SimpleInventory(9, 1);
        private final List<InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe>> variableEvaluators;
        private final List<IngredientInstanceWrapper<?, ?>> inventoryOutputBuffer;
        private final Int2ObjectMap<IFormattableTextComponent> recipeSlotMessages;
        private final Int2BooleanMap recipeSlotValidated;
        private final IntSet delayedRecipeReloads;
        private final Map<IVariable, Boolean> variableListeners;
        private int channelCrafting = 0;
        private boolean disableCraftingCheck = false;
        private final Int2ObjectMap<IRecipeDefinition> currentRecipes;
        private PartTarget target = null;
        private INetwork network = null;
        private ICraftingNetwork craftingNetwork = null;
        private IPartNetwork partNetwork = null;
        private int channel = -1;
        private boolean shouldAddToCraftingNetwork = false;
        private PlayerEntity lastPlayer;

        public State() {
            this.inventoryVariables.addDirtyMarkListener((IDirtyMarkListener)this);
            this.variableEvaluators = Lists.newArrayList();
            this.inventoryOutputBuffer = Lists.newArrayList();
            this.recipeSlotMessages = new Int2ObjectArrayMap();
            this.recipeSlotValidated = new Int2BooleanArrayMap();
            this.delayedRecipeReloads = new IntArraySet();
            this.variableListeners = new MapMaker().weakKeys().makeMap();
            this.currentRecipes = new Int2ObjectArrayMap();
        }

        protected int getDefaultUpdateInterval() {
            return GeneralConfig.minCraftingInterfaceUpdateFreq;
        }

        public SimpleInventory getInventoryVariables() {
            return this.inventoryVariables;
        }

        public void writeToNBT(CompoundNBT tag) {
            super.writeToNBT(tag);
            this.inventoryVariables.writeToNBT(tag, "variables");
            ListNBT instanceTags = new ListNBT();
            for (IngredientInstanceWrapper<?, ?> ingredientInstanceWrapper : this.inventoryOutputBuffer) {
                CompoundNBT instanceTag = new CompoundNBT();
                instanceTag.func_74778_a("component", ingredientInstanceWrapper.getComponent().getRegistryName().toString());
                instanceTag.func_218657_a("instance", ingredientInstanceWrapper.getComponent().getSerializer().serializeInstance(ingredientInstanceWrapper.getInstance()));
                instanceTags.add((Object)instanceTag);
            }
            tag.func_218657_a("inventoryOutputBuffer", (INBT)instanceTags);
            this.craftingJobHandler.writeToNBT(tag);
            tag.func_74768_a("channelCrafting", this.channelCrafting);
            CompoundNBT recipeSlotErrorsTag = new CompoundNBT();
            for (Int2ObjectMap.Entry entry : this.recipeSlotMessages.int2ObjectEntrySet()) {
                NBTClassType.writeNbt(IFormattableTextComponent.class, (String)String.valueOf(entry.getIntKey()), (Object)entry.getValue(), (CompoundNBT)recipeSlotErrorsTag);
            }
            tag.func_218657_a("recipeSlotMessages", (INBT)recipeSlotErrorsTag);
            CompoundNBT compoundNBT = new CompoundNBT();
            for (Int2BooleanMap.Entry entry : this.recipeSlotValidated.int2BooleanEntrySet()) {
                compoundNBT.func_74757_a(String.valueOf(entry.getIntKey()), entry.getBooleanValue());
            }
            tag.func_218657_a("recipeSlotValidated", (INBT)compoundNBT);
            tag.func_74757_a("disableCraftingCheck", this.disableCraftingCheck);
        }

        public void readFromNBT(CompoundNBT tag) {
            super.readFromNBT(tag);
            this.inventoryVariables.readFromNBT(tag, "variables");
            this.inventoryOutputBuffer.clear();
            for (Object instanceTagRaw : tag.func_150295_c("inventoryOutputBuffer", 10)) {
                CompoundNBT instanceTag = (CompoundNBT)instanceTagRaw;
                String componentName = instanceTag.func_74779_i("component");
                IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
                this.inventoryOutputBuffer.add(new IngredientInstanceWrapper(component, component.getSerializer().deserializeInstance(instanceTag.func_74781_a("instance"))));
            }
            this.craftingJobHandler.readFromNBT(tag);
            this.channelCrafting = tag.func_74762_e("channelCrafting");
            this.recipeSlotMessages.clear();
            CompoundNBT recipeSlotErrorsTag = tag.func_74775_l("recipeSlotMessages");
            for (String slot : recipeSlotErrorsTag.func_150296_c()) {
                IFormattableTextComponent unlocalizedString = (IFormattableTextComponent)NBTClassType.readNbt(IFormattableTextComponent.class, (String)slot, (CompoundNBT)recipeSlotErrorsTag);
                this.recipeSlotMessages.put(Integer.parseInt(slot), (Object)unlocalizedString);
            }
            this.recipeSlotValidated.clear();
            CompoundNBT recipeSlotValidatedTag = tag.func_74775_l("recipeSlotValidated");
            for (String slot : recipeSlotValidatedTag.func_150296_c()) {
                this.recipeSlotValidated.put(Integer.parseInt(slot), recipeSlotValidatedTag.func_74767_n(slot));
            }
            this.disableCraftingCheck = tag.func_74767_n("disableCraftingCheck");
        }

        public void setChannelCrafting(int channelCrafting) {
            if (this.channelCrafting != channelCrafting) {
                if (this.craftingNetwork != null) {
                    this.craftingNetwork.removeCraftingInterface(this.channelCrafting, this);
                }
                this.channelCrafting = channelCrafting;
                if (this.craftingNetwork != null) {
                    this.craftingNetwork.addCraftingInterface(this.channelCrafting, this);
                }
                this.sendUpdate();
            }
        }

        public int getChannelCrafting() {
            return this.channelCrafting;
        }

        public void reloadRecipes() {
            this.currentRecipes.clear();
            this.recipeSlotMessages.clear();
            this.recipeSlotValidated.clear();
            this.variableEvaluators.clear();
            int i = 0;
            while (i < this.getInventoryVariables().func_70302_i_()) {
                final int slot = i++;
                this.variableEvaluators.add(new InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe>((IInventory)this.getInventoryVariables(), slot, (IValueType)ValueTypes.OBJECT_RECIPE){

                    public void onErrorsChanged() {
                        super.onErrorsChanged();
                        this.setLocalErrors(slot, this.getErrors());
                    }
                });
            }
            if (this.partNetwork != null) {
                for (i = 0; i < this.getInventoryVariables().func_70302_i_(); ++i) {
                    this.reloadRecipe(i);
                }
            }
        }

        private void setLocalErrors(int slot, List<IFormattableTextComponent> errors) {
            if (errors.isEmpty()) {
                if (this.recipeSlotMessages.size() > slot) {
                    this.recipeSlotMessages.remove(slot);
                }
            } else {
                this.recipeSlotMessages.put(slot, (Object)errors.get(0));
            }
        }

        protected void reloadRecipe(int slot) {
            this.currentRecipes.remove(slot);
            if (this.recipeSlotMessages.size() > slot) {
                this.recipeSlotMessages.remove(slot);
            }
            if (this.recipeSlotValidated.size() > slot) {
                this.recipeSlotValidated.remove(slot);
            }
            if (this.partNetwork != null) {
                IVariable variable;
                block14: {
                    InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe> evaluator = this.variableEvaluators.get(slot);
                    evaluator.refreshVariable(this.network, false);
                    variable = evaluator.getVariable(this.network);
                    if (variable != null) {
                        try {
                            IValue value;
                            if (!this.variableListeners.containsKey(variable)) {
                                variable.addInvalidationListener(() -> {
                                    this.variableListeners.remove(variable);
                                    this.delayedReloadRecipe(slot);
                                });
                                this.variableListeners.put(variable, true);
                            }
                            if ((value = variable.getValue()).getType() == ValueTypes.OBJECT_RECIPE) {
                                Optional recipeWrapper = ((ValueObjectTypeRecipe.ValueRecipe)value).getRawValue();
                                if (recipeWrapper.isPresent()) {
                                    IRecipeDefinition recipe = (IRecipeDefinition)recipeWrapper.get();
                                    if (!GeneralConfig.validateRecipesCraftingInterface || this.disableCraftingCheck || this.isValid(recipe)) {
                                        this.currentRecipes.put(slot, (Object)recipe);
                                        this.recipeSlotValidated.put(slot, true);
                                        this.recipeSlotMessages.put(slot, (Object)new TranslationTextComponent("gui.integratedcrafting.partinterface.slot.message.valid"));
                                    } else {
                                        this.recipeSlotMessages.put(slot, (Object)new TranslationTextComponent("gui.integratedcrafting.partinterface.slot.message.invalid"));
                                    }
                                }
                                break block14;
                            }
                            this.recipeSlotMessages.put(slot, (Object)new TranslationTextComponent("gui.integratedcrafting.partinterface.slot.message.norecipe"));
                        }
                        catch (EvaluationException e) {
                            this.recipeSlotMessages.put(slot, (Object)e.getErrorMessage());
                        }
                    } else {
                        this.recipeSlotMessages.put(slot, (Object)new TranslationTextComponent("gui.integratedcrafting.partinterface.slot.message.norecipe"));
                    }
                }
                try {
                    IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked((INetwork)this.network);
                    MinecraftForge.EVENT_BUS.post((Event)new PartVariableDrivenVariableContentsUpdatedEvent(this.network, partNetwork, this.getTarget(), (IPartType)PartTypes.INTERFACE_CRAFTING, (IPartState)this, this.lastPlayer, variable, variable != null ? variable.getValue() : null));
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
            }
            this.sendUpdate();
        }

        public void setLastPlayer(PlayerEntity lastPlayer) {
            this.lastPlayer = lastPlayer;
        }

        private void delayedReloadRecipe(int slot) {
            this.delayedRecipeReloads.add(slot);
        }

        private boolean isValid(IRecipeDefinition recipe) {
            DimPos dimPos = this.getTarget().getTarget().getPos();
            Direction side = this.getTarget().getTarget().getSide();
            IRecipeHandler recipeHandler = (IRecipeHandler)TileHelpers.getCapability((IBlockReader)dimPos.getWorld(true), (BlockPos)dimPos.getBlockPos(), (Direction)side, Capabilities.RECIPE_HANDLER).orElse(null);
            if (recipeHandler == null) {
                BlockState blockState = dimPos.getWorld(true).func_180495_p(dimPos.getBlockPos());
                recipeHandler = (IRecipeHandler)BlockCapabilities.getInstance().getCapability(blockState, Capabilities.RECIPE_HANDLER, (IBlockReader)dimPos.getWorld(true), dimPos.getBlockPos(), side).orElse(null);
            }
            if (recipeHandler != null) {
                IMixedIngredients simulatedOutput = recipeHandler.simulate((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)recipe));
                if (simulatedOutput != null && !simulatedOutput.isEmpty()) {
                    if (recipe.getOutput().containsAll(simulatedOutput)) {
                        return true;
                    }
                    if (GeneralConfig.logRecipeValidationFailures) {
                        IntegratedCrafting.clog(Level.INFO, "Recipe validation failure: incompatible recipe output and simulated output:\nRecipe output: " + recipe.getOutput() + "\nSimulated output: " + simulatedOutput);
                    }
                    return false;
                }
                if (GeneralConfig.logRecipeValidationFailures) {
                    IntegratedCrafting.clog(Level.INFO, "Recipe validation failure: No output was obtained when simulating a recipe\n" + recipe);
                }
                return false;
            }
            return true;
        }

        public void onDirty() {
            super.onDirty();
            if (this.craftingNetwork != null) {
                this.craftingNetwork.removeCraftingInterface(this.channelCrafting, this);
            }
            if (this.getTarget() != null && !this.getTarget().getCenter().getPos().getWorld((boolean)true).field_72995_K) {
                this.reloadRecipes();
            }
            if (this.craftingNetwork != null) {
                this.craftingNetwork.addCraftingInterface(this.channelCrafting, this);
            }
        }

        public void setTarget(PartTarget target) {
            this.target = target;
        }

        public PartTarget getTarget() {
            return this.target;
        }

        public void setNetworks(@Nullable INetwork network, @Nullable ICraftingNetwork craftingNetwork, @Nullable IPartNetwork partNetwork, int channel) {
            this.network = network;
            this.craftingNetwork = craftingNetwork;
            this.partNetwork = partNetwork;
            this.channel = channel;
            this.reloadRecipes();
            if (network != null) {
                this.getCraftingJobHandler().reRegisterObservers(network);
            }
        }

        public ICraftingNetwork getCraftingNetwork() {
            return this.craftingNetwork;
        }

        public int getChannel() {
            return this.channel;
        }

        @Override
        public Collection<IRecipeDefinition> getRecipes() {
            return this.currentRecipes.values();
        }

        public Int2ObjectMap<IRecipeDefinition> getRecipesIndexed() {
            return this.currentRecipes;
        }

        @Override
        public boolean canScheduleCraftingJobs() {
            return this.getCraftingJobHandler().canScheduleCraftingJobs();
        }

        @Override
        public void scheduleCraftingJob(CraftingJob craftingJob) {
            this.getCraftingJobHandler().scheduleCraftingJob(craftingJob);
        }

        @Override
        public int getCraftingJobsCount() {
            return this.craftingJobHandler.getAllCraftingJobs().size();
        }

        @Override
        public Iterator<CraftingJob> getCraftingJobs() {
            return this.craftingJobHandler.getAllCraftingJobs().values().iterator();
        }

        @Override
        public Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> getPendingCraftingJobOutputs(int craftingJobId) {
            Map pending = (Map)this.craftingJobHandler.getProcessingCraftingJobsPendingIngredients().get(craftingJobId);
            if (pending == null) {
                pending = Maps.newIdentityHashMap();
            }
            return pending;
        }

        @Override
        public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
            return this.craftingJobHandler.getCraftingJobStatus(network, channel, craftingJobId);
        }

        @Override
        public void cancelCraftingJob(int channel, int craftingJobId) {
            this.craftingJobHandler.markCraftingJobFinished(craftingJobId);
        }

        @Override
        public PrioritizedPartPos getPosition() {
            return PrioritizedPartPos.of((PartPos)this.getTarget().getCenter(), (int)this.getPriority());
        }

        public CraftingJobHandler getCraftingJobHandler() {
            return this.craftingJobHandler;
        }

        public boolean shouldAddToCraftingNetwork() {
            return this.shouldAddToCraftingNetwork;
        }

        public void setShouldAddToCraftingNetwork(boolean shouldAddToCraftingNetwork) {
            this.shouldAddToCraftingNetwork = shouldAddToCraftingNetwork;
        }

        public List<IngredientInstanceWrapper<?, ?>> getInventoryOutputBuffer() {
            return this.inventoryOutputBuffer;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            Object cap;
            IngredientComponent ingredientComponent;
            if (capability == CraftingInterfaceConfig.CAPABILITY) {
                return LazyOptional.of(() -> this).cast();
            }
            if (this.network != null && (ingredientComponent = IngredientComponent.getIngredientComponentForStorageCapability(capability)) != null && (cap = this.wrapStorageCapability(capability, ingredientComponent)) != null) {
                return LazyOptional.of(() -> cap);
            }
            return super.getCapability(capability, network, partNetwork, target);
        }

        protected <C, T, M> C wrapStorageCapability(Capability<C> capability, IngredientComponent<T, M> ingredientComponent) {
            Object storage = CraftingHelpers.getNetworkStorage(this.network, this.channelCrafting, ingredientComponent, false);
            storage = new IngredientComponentStorageSlottedInsertProxy<T, M>(storage);
            return (C)ingredientComponent.getStorageWrapperHandler(capability).wrapStorage(storage);
        }

        @Override
        public <T, M> void addResult(IngredientComponent<T, M> ingredientComponent, T instance) {
            this.getInventoryOutputBuffer().add(new IngredientInstanceWrapper(ingredientComponent, instance));
        }

        public void setIngredientComponentTargetSideOverride(IngredientComponent<?, ?> ingredientComponent, Direction side) {
            if (this.getTarget().getTarget().getSide() == side) {
                this.craftingJobHandler.setIngredientComponentTarget(ingredientComponent, null);
            } else {
                this.craftingJobHandler.setIngredientComponentTarget(ingredientComponent, side);
            }
            this.sendUpdate();
        }

        public Direction getIngredientComponentTargetSideOverride(IngredientComponent<?, ?> ingredientComponent) {
            Direction side = this.craftingJobHandler.getIngredientComponentTarget(ingredientComponent);
            if (side == null) {
                side = this.getTarget().getTarget().getSide();
            }
            return side;
        }

        public boolean isRecipeSlotValid(int slot) {
            return this.recipeSlotValidated.containsKey(slot);
        }

        @Nullable
        public IFormattableTextComponent getRecipeSlotUnlocalizedMessage(int slot) {
            return (IFormattableTextComponent)this.recipeSlotMessages.get(slot);
        }

        public IntSet getDelayedRecipeReloads() {
            return this.delayedRecipeReloads;
        }

        public void setDisableCraftingCheck(boolean disableCraftingCheck) {
            if (disableCraftingCheck != this.disableCraftingCheck) {
                this.disableCraftingCheck = disableCraftingCheck;
                this.sendUpdate();
            }
        }

        public boolean isDisableCraftingCheck() {
            return this.disableCraftingCheck;
        }
    }
}

