/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.world;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ModWorldgenRegistration {
    private static final RuleTest END_STONE_RULE_TEST = new BlockMatchRuleTest(Blocks.field_150377_bs);
    private static ConfiguredFeature<?, ?> configuredNetherProsperityOreFeature;
    private static ConfiguredFeature<?, ?> configuredNetherInferiumOreFeature;
    private static ConfiguredFeature<?, ?> configuredEndProsperityOreFeature;
    private static ConfiguredFeature<?, ?> configuredEndInferiumOreFeature;

    @SubscribeEvent
    public void onBiomesLoading(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        switch (category) {
            case NETHER: {
                if (((Boolean)ModConfigs.GENERATE_NETHER_PROSPERITY.get()).booleanValue()) {
                    generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, configuredNetherProsperityOreFeature);
                }
                if (!((Boolean)ModConfigs.GENERATE_NETHER_INFERIUM.get()).booleanValue()) break;
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, configuredNetherInferiumOreFeature);
                break;
            }
            case THEEND: {
                if (((Boolean)ModConfigs.GENERATE_END_PROSPERITY.get()).booleanValue()) {
                    generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, configuredEndProsperityOreFeature);
                }
                if (!((Boolean)ModConfigs.GENERATE_END_INFERIUM.get()).booleanValue()) break;
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, configuredEndInferiumOreFeature);
                break;
            }
        }
    }

    public static void onCommonSetup() {
        int size = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_SIZE.get();
        int rate = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_RATE.get();
        int height = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_HEIGHT.get();
        OreFeatureConfig config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)ModBlocks.NETHER_PROSPERITY_ORE.get()).func_176223_P(), size);
        configuredNetherProsperityOreFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagradditions", "nether_prosperity_ore"), configuredNetherProsperityOreFeature);
        size = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_SIZE.get();
        rate = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_RATE.get();
        height = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_HEIGHT.get();
        config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)ModBlocks.NETHER_INFERIUM_ORE.get()).func_176223_P(), size);
        configuredNetherInferiumOreFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagradditions", "nether_inferium_ore"), configuredNetherInferiumOreFeature);
        size = (Integer)ModConfigs.END_PROSPERITY_SPAWN_SIZE.get();
        rate = (Integer)ModConfigs.END_PROSPERITY_SPAWN_RATE.get();
        height = (Integer)ModConfigs.END_PROSPERITY_SPAWN_HEIGHT.get();
        config = new OreFeatureConfig(END_STONE_RULE_TEST, ((Block)ModBlocks.END_PROSPERITY_ORE.get()).func_176223_P(), size);
        configuredEndProsperityOreFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagradditions", "end_prosperity_ore"), configuredEndProsperityOreFeature);
        size = (Integer)ModConfigs.END_INFERIUM_SPAWN_SIZE.get();
        rate = (Integer)ModConfigs.END_INFERIUM_SPAWN_RATE.get();
        height = (Integer)ModConfigs.END_INFERIUM_SPAWN_HEIGHT.get();
        config = new OreFeatureConfig(END_STONE_RULE_TEST, ((Block)ModBlocks.END_INFERIUM_ORE.get()).func_176223_P(), size);
        configuredEndInferiumOreFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagradditions", "end_inferium_ore"), configuredEndInferiumOreFeature);
    }
}

