/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.compat.tconstruct.modifier;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class SoulSiphonerModifier
extends Modifier {
    public SoulSiphonerModifier() {
        super(9197116);
    }

    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        block3: {
            LivingEntity target = context.getLivingTarget();
            LivingEntity attacker = context.getAttacker();
            if (target == null || target.func_70089_S() || !(attacker instanceof PlayerEntity)) break block3;
            IMobSoulType type = MysticalAgricultureAPI.getMobSoulTypeRegistry().getMobSoulTypeByEntity(target);
            if (type == null || !type.isEnabled()) {
                return super.afterEntityHit(tool, level, context, damageDealt);
            }
            PlayerEntity player = (PlayerEntity)attacker;
            List<ItemStack> jars = SoulSiphonerModifier.getValidSoulJars(player, type);
            if (!jars.isEmpty()) {
                ItemStack jar;
                double remaining = 0.25 * (double)level;
                Iterator<ItemStack> iterator = jars.iterator();
                while (iterator.hasNext() && !((remaining = MobSoulUtils.addSoulsToJar((ItemStack)(jar = iterator.next()), (IMobSoulType)type, (double)remaining)) <= 0.0)) {
                }
            }
        }
        return super.afterEntityHit(tool, level, context, damageDealt);
    }

    private static List<ItemStack> getValidSoulJars(PlayerEntity player, IMobSoulType type) {
        return player.field_71071_by.field_70462_a.stream().filter(s -> {
            ResourceLocation id = s.func_77973_b().getRegistryName();
            return id != null && "mysticalagriculture:soul_jar".equals(id.toString());
        }).filter(s -> MobSoulUtils.canAddTypeToJar((ItemStack)s, (IMobSoulType)type)).sorted((a, b) -> MobSoulUtils.getType((ItemStack)a) != null ? -1 : (MobSoulUtils.getType((ItemStack)b) != null ? 0 : 1)).collect(Collectors.toList());
    }
}

