/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice.packets;

import com.supermartijn642.wormhole.packet.TargetDevicePacket;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class TargetDeviceMovePacket
extends TargetDevicePacket {
    private int index;
    private boolean up;

    public TargetDeviceMovePacket(Hand hand, int index, boolean up) {
        super(hand);
        this.index = index;
        this.up = up;
    }

    public TargetDeviceMovePacket(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        super.encode(buffer);
        buffer.writeInt(this.index);
        buffer.writeBoolean(this.up);
    }

    @Override
    protected void decodeBuffer(PacketBuffer buffer) {
        super.decodeBuffer(buffer);
        this.index = buffer.readInt();
        this.up = buffer.readBoolean();
    }

    @Override
    protected void handle(PlayerEntity player, World world, ItemStack targetDevice) {
        List<PortalTarget> targets = TargetDeviceItem.getTargets(targetDevice);
        if (this.index < 0 || this.index > targets.size() - 1) {
            return;
        }
        TargetDeviceItem.moveTarget(targetDevice, this.index, this.up);
    }
}

