/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class TargetCellTileRenderer
extends TileEntityRenderer<TargetCellTile> {
    public static final ResourceLocation[] BASIC_TARGET_CELL_MODELS;
    public static final ResourceLocation[] ADVANCED_TARGET_CELL_MODELS;

    public TargetCellTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TargetCellTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ResourceLocation modelLocation = null;
        double percent = (double)tile.getNonNullTargetCount() / (double)tile.getTargetCapacity();
        if (tile.field_200663_e == TargetCellType.BASIC) {
            modelLocation = BASIC_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(BASIC_TARGET_CELL_MODELS.length - 1))];
        } else if (tile.field_200663_e == TargetCellType.ADVANCED) {
            modelLocation = ADVANCED_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(ADVANCED_TARGET_CELL_MODELS.length - 1))];
        }
        IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(modelLocation);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel((IBlockDisplayReader)tile.func_145831_w(), model, tile.func_195044_w(), tile.func_174877_v(), matrixStack, buffer.getBuffer(RenderType.func_228639_c_()), true, new Random(), 42L, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
    }

    public static IBakedModel getModelForTile(TargetCellTile tile) {
        ResourceLocation modelLocation = null;
        double percent = (double)tile.getNonNullTargetCount() / (double)tile.getTargetCapacity();
        if (tile.field_200663_e == TargetCellType.BASIC) {
            modelLocation = BASIC_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(BASIC_TARGET_CELL_MODELS.length - 1))];
        } else if (tile.field_200663_e == TargetCellType.ADVANCED) {
            modelLocation = ADVANCED_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(ADVANCED_TARGET_CELL_MODELS.length - 1))];
        }
        return Minecraft.func_71410_x().func_209506_al().getModel(modelLocation);
    }

    static {
        int i;
        BASIC_TARGET_CELL_MODELS = new ResourceLocation[5];
        ADVANCED_TARGET_CELL_MODELS = new ResourceLocation[9];
        for (i = 0; i < 5; ++i) {
            TargetCellTileRenderer.BASIC_TARGET_CELL_MODELS[i] = new ResourceLocation("wormhole", "block/target_cell/basic_target_cell_" + i);
        }
        for (i = 0; i < 9; ++i) {
            TargetCellTileRenderer.ADVANCED_TARGET_CELL_MODELS[i] = new ResourceLocation("wormhole", "block/target_cell/advanced_target_cell_" + i);
        }
    }
}

