/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalActivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalDeactivatePacket;
import com.supermartijn642.wormhole.portal.screen.PortalGroupScreen;
import com.supermartijn642.wormhole.portal.screen.PortalRendererHelper;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.EnergyBarWidget;
import com.supermartijn642.wormhole.screen.WormholeButton;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PortalOverviewScreen
extends PortalGroupScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("wormhole", "textures/gui/portal_overview_screen.png");
    private static final ResourceLocation LOCATION_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/location_icon.png");
    private static final ResourceLocation ENERGY_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/lightning_icon.png");
    private static final ResourceLocation TELEPORT_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/teleport_icon.png");
    private static final ResourceLocation STAR_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/star_icon.png");
    private static final ResourceLocation DIMENSION_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/dimension_icon.png");
    private static final ResourceLocation CHECKMARK_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/checkmark_icon.png");
    private static final ResourceLocation CROSS_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/cross_icon.png");
    private static final ResourceLocation WARNING_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/warning_icon.png");
    private static final ResourceLocation SEPARATOR = new ResourceLocation("wormhole", "textures/gui/select_target_screen/separator.png");
    private static final int WIDTH = 280;
    private static final int HEIGHT = 185;
    private WormholeColoredButton activateButton;

    public PortalOverviewScreen(BlockPos pos) {
        super("wormhole.portal.gui.title", pos);
    }

    protected float sizeX(PortalGroup group) {
        return 280.0f;
    }

    protected float sizeY(PortalGroup group) {
        return 185.0f;
    }

    protected void addWidgets(PortalGroup group) {
        this.activateButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(45, 159, 60, 15, "", () -> {
            PortalGroup group2 = this.getObject();
            if (group2 != null) {
                Wormhole.CHANNEL.sendToServer((Object)(group2.isActive() ? new PortalDeactivatePacket(group2) : new PortalActivatePacket(group2)));
            }
        }));
        Supplier<Integer> energy = () -> this.getFromPortalGroup(PortalGroup::getStoredEnergy, 0);
        Supplier<Integer> capacity = () -> this.getFromPortalGroup(PortalGroup::getEnergyCapacity, 0);
        this.addWidget((Widget)new EnergyBarWidget(244, 55, 30, 82, energy, capacity));
        this.addWidget((Widget)new WormholeButton(151, 159, 82, 13, "wormhole.portal.gui.change_target", () -> ClientProxy.openPortalTargetScreen(this.pos)));
    }

    protected void render(MatrixStack matrixStack, int mouseX, int mouseY, PortalGroup group) {
        this.activateButton.setTextKey(group.isActive() ? "wormhole.portal.gui.deactivate" : "wormhole.portal.gui.activate");
        if (group.isActive()) {
            this.activateButton.setColorRed();
        } else {
            this.activateButton.setColorGreen();
        }
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)this.field_230704_d_, (float)72.5f, (float)3.0f, (int)Integer.MAX_VALUE);
        PortalTarget target = group.getActiveTarget();
        this.renderInfo(matrixStack, group.getStoredEnergy(), group.getIdleEnergyCost(), group.getTeleportEnergyCost(), target);
        PortalRendererHelper.drawPortal(group.shape, this.left() + 8.0f, this.top() + 19.0f, 132.0f, 132.0f);
    }

    private void renderInfo(MatrixStack matrixStack, int storedEnergy, int idleCost, int teleportCost, PortalTarget target) {
        PortalStatus status = target == null ? PortalStatus.NO_TARGET : (storedEnergy == 0 ? PortalStatus.NO_ENERGY : (storedEnergy < idleCost ? PortalStatus.NOT_ENOUGH_ENERGY : PortalStatus.OK));
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.information"), (float)192.0f, (float)31.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)154.0f, (float)41.0f, (float)77.0f, (float)1.0f);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)status.getIcon());
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)151.0f, (float)47.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)status.getStatus(), (float)162.0f, (float)48.0f, (int)Integer.MAX_VALUE);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)ENERGY_ICON);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)151.0f, (float)59.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (String)EnergyFormat.formatEnergyPerTick(idleCost), (float)162.0f, (float)60.0f, (int)Integer.MAX_VALUE);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)TELEPORT_ICON);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)150.0f, (float)70.0f, (float)11.0f, (float)11.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (String)(target == null ? "--" : EnergyFormat.formatEnergy(teleportCost)), (float)162.0f, (float)72.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)154.0f, (float)85.0f, (float)77.0f, (float)1.0f);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)STAR_ICON);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)151.0f, (float)91.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (String)(target == null ? "--" : target.name), (float)162.0f, (float)92.0f, (int)Integer.MAX_VALUE);
        if (target != null) {
            GlStateManager.func_227709_e_();
            ScreenUtils.bindTexture((ResourceLocation)LOCATION_ICON);
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)151.0f, (float)103.0f, (float)9.0f, (float)9.0f);
            ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("(" + target.x + ", " + target.y + ", " + target.z + ")"), (float)162.0f, (float)104.0f, (int)Integer.MAX_VALUE);
            Block block = null;
            if (target.dimension.equals(World.field_234918_g_.func_240901_a_().toString())) {
                block = Blocks.field_185774_da;
            } else if (target.dimension.equals(World.field_234919_h_.func_240901_a_().toString())) {
                block = Blocks.field_150424_aL;
            } else if (target.dimension.equals(World.field_234920_i_.func_240901_a_().toString())) {
                block = Blocks.field_150377_bs;
            }
            if (block == null) {
                ScreenUtils.bindTexture((ResourceLocation)DIMENSION_ICON);
                ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)151.0f, (float)115.0f, (float)9.0f, (float)9.0f);
            } else {
                ScreenBlockRenderer.drawBlock(block, (double)this.left() + 155.5, (double)this.top() + 119.5, 5.5, 45.0f, 40.0f);
            }
            ScreenUtils.drawString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)target.getDimensionDisplayName(), (float)162.0f, (float)116.0f, (int)Integer.MAX_VALUE);
        }
    }

    protected void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY, PortalGroup group) {
        if (mouseX >= 150 && mouseX <= 161 && mouseY >= 46 && mouseY <= 57) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.status"), mouseX, mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 58 && mouseY <= 69) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.idle_cost"), mouseX, mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 70 && mouseY <= 81) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.teleport_cost"), mouseX, mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 90 && mouseY <= 101) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.target"), mouseX, mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 102 && mouseY <= 113) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.target_location"), mouseX, mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 114 && mouseY <= 125) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("wormhole.portal.gui.target_dimension"), mouseX, mouseY);
        }
    }

    static /* synthetic */ ResourceLocation access$000() {
        return CHECKMARK_ICON;
    }

    static /* synthetic */ ResourceLocation access$100() {
        return CROSS_ICON;
    }

    static /* synthetic */ ResourceLocation access$200() {
        return WARNING_ICON;
    }

    private static enum PortalStatus {
        OK("ok", TextFormatting.GREEN, PortalOverviewScreen.access$000()),
        NOT_ENOUGH_ENERGY("not_enough_energy", TextFormatting.RED, PortalOverviewScreen.access$100()),
        NO_ENERGY("no_energy", TextFormatting.RED, PortalOverviewScreen.access$100()),
        NO_TARGET("no_target", TextFormatting.GOLD, PortalOverviewScreen.access$200()),
        NO_DIMENSIONAL_CORE("no_dimensional_core", TextFormatting.RED, PortalOverviewScreen.access$100());

        private final String status;
        private final TextFormatting color;
        private final ResourceLocation icon;

        private PortalStatus(String status, TextFormatting color, ResourceLocation icon) {
            this.status = status;
            this.color = color;
            this.icon = icon;
        }

        public ITextComponent getStatus() {
            return new TranslationTextComponent("wormhole.portal.gui.status." + this.status).func_240699_a_(this.color);
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }
    }
}

