/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import java.util.Optional;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class PortalTarget {
    public static final int MAX_NAME_LENGTH = 10;
    public final String dimension;
    public final int x;
    public final int y;
    public final int z;
    public final float yaw;
    public String name;
    public DyeColor color = null;
    public String dimensionDisplayName;

    public PortalTarget(String dimension, int x, int y, int z, float yaw, String name) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.name = name;
        String dimensionName = dimension.substring(Math.min(dimension.length() - 1, Math.max(0, dimension.indexOf(58) + 1))).toLowerCase();
        dimensionName = dimensionName.substring(0, 1).toUpperCase() + dimensionName.substring(1);
        for (int i = 0; i < dimensionName.length() - 1; ++i) {
            if (dimensionName.charAt(i) != '_' || !Character.isAlphabetic(dimensionName.charAt(i + 1))) continue;
            dimensionName = dimensionName.substring(0, i) + ' ' + (i + 2 < dimensionName.length() ? dimensionName.substring(i + 1, i + 2).toUpperCase() + dimensionName.substring(i + 2) : dimensionName.substring(i + 1).toUpperCase());
        }
        this.dimensionDisplayName = dimensionName;
    }

    public PortalTarget(World world, BlockPos pos, float yaw, String name) {
        this(world.func_234923_W_().func_240901_a_().toString(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), yaw, name);
    }

    public PortalTarget(CompoundNBT tag) {
        this(tag.func_74779_i("dimension"), tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74760_g("yaw"), tag.func_74764_b("name") ? tag.func_74779_i("name") : "Target Destination");
        this.color = tag.func_74764_b("color") ? DyeColor.func_196056_a((int)tag.func_74762_e("color")) : null;
        String dimensionName = this.dimension.substring(Math.min(this.dimension.length() - 1, Math.max(0, this.dimension.indexOf(58) + 1))).toLowerCase();
        dimensionName = dimensionName.substring(0, 1).toUpperCase() + dimensionName.substring(1);
        for (int i = 0; i < dimensionName.length() - 1; ++i) {
            if (dimensionName.charAt(i) != '_' || !Character.isAlphabetic(dimensionName.charAt(i + 1))) continue;
            dimensionName = dimensionName.substring(0, i) + ' ' + (i + 2 < dimensionName.length() ? dimensionName.substring(i + 1, i + 2).toUpperCase() + dimensionName.substring(i + 2) : dimensionName.substring(i + 1).toUpperCase());
        }
        this.dimensionDisplayName = dimensionName;
    }

    public static PortalTarget read(CompoundNBT tag) {
        return new PortalTarget(tag);
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("dimension", this.dimension);
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        tag.func_74776_a("yaw", this.yaw);
        tag.func_74778_a("name", this.name);
        if (this.color != null) {
            tag.func_74768_a("color", this.color.func_196059_a());
        }
        return tag;
    }

    public Optional<World> getWorld(MinecraftServer server) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.dimension));
        return Optional.ofNullable(server.func_71218_a(key));
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vector3d getCenteredPos() {
        return new Vector3d((double)this.x + 0.5, (double)this.y + 0.2, (double)this.z + 0.5);
    }

    public String getDimensionDisplayName() {
        return this.dimensionDisplayName;
    }
}

