/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.google.common.collect.Lists;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.StabilizerTile;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellTile;
import com.supermartijn642.wormhole.portal.IPortalGroupTile;
import com.supermartijn642.wormhole.portal.ITargetCellTile;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PortalShape {
    public static final Map<Direction.Axis, List<BlockPos>> DIRECT_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    private static final Map<Direction.Axis, List<BlockPos>> INDIRECT_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    private static final Map<Direction.Axis, List<BlockPos>> ALL_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    public final Direction.Axis axis;
    public final List<BlockPos> area = new ArrayList<BlockPos>();
    public final List<BlockPos> frame = new ArrayList<BlockPos>();
    public final List<BlockPos> stabilizers = new ArrayList<BlockPos>();
    public final List<BlockPos> energyCells = new ArrayList<BlockPos>();
    public final List<BlockPos> targetCells = new ArrayList<BlockPos>();
    public final double span;
    public final BlockPos minCorner;
    public final BlockPos maxCorner;

    public static PortalShape find(IBlockReader world, BlockPos center) {
        for (Direction.Axis axis : Direction.Axis.values()) {
            PortalShape shape = PortalShape.find(world, center, axis);
            if (shape == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape find(IBlockReader world, BlockPos center, Direction.Axis axis) {
        for (BlockPos offset : ALL_OFFSETS.get(axis)) {
            PortalShape shape;
            if (world.func_180495_p(center.func_177971_a((Vector3i)offset)).func_177230_c() != Blocks.field_150350_a || (shape = PortalShape.findArea(world, center.func_177971_a((Vector3i)offset), axis)) == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape findArea(IBlockReader world, BlockPos start, Direction.Axis axis) {
        LinkedList<BlockPos> next = new LinkedList<BlockPos>();
        LinkedList<BlockPos> current = new LinkedList<BlockPos>();
        current.add(start);
        ArrayList<BlockPos> done = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        ArrayList<BlockPos> corners = new ArrayList<BlockPos>();
        ArrayList<BlockPos> stabilizers = new ArrayList<BlockPos>();
        ArrayList<BlockPos> energyCells = new ArrayList<BlockPos>();
        ArrayList<BlockPos> targetCells = new ArrayList<BlockPos>();
        while (!current.isEmpty()) {
            for (BlockPos pos : current) {
                int frames = 0;
                for (BlockPos offset : DIRECT_OFFSETS.get(axis)) {
                    BlockPos offPos = pos.func_177971_a((Vector3i)offset);
                    Block block = world.func_180495_p(offPos).func_177230_c();
                    TileEntity tile = world.func_175625_s(offPos);
                    if (block == Blocks.field_150350_a) {
                        if (done.contains(offPos) || current.contains(offPos) || next.contains(offPos)) continue;
                        next.add(offPos);
                        continue;
                    }
                    if (tile instanceof IPortalGroupTile && !((IPortalGroupTile)tile).hasGroup()) {
                        if (!frame.contains(offPos)) {
                            frame.add(offPos);
                            if (tile instanceof StabilizerTile) {
                                stabilizers.add(offPos);
                            }
                            if (tile instanceof IEnergyCellTile) {
                                energyCells.add(offPos);
                            }
                            if (tile instanceof ITargetCellTile) {
                                targetCells.add(offPos);
                            }
                        }
                        ++frames;
                        continue;
                    }
                    return null;
                }
                if (frames < 2) continue;
                corners.add(pos);
            }
            if (done.size() + current.size() + next.size() > WormholeConfig.maxPortalSize.get()) {
                return null;
            }
            done.addAll(current);
            current.clear();
            current.addAll(next);
            next.clear();
        }
        if (WormholeConfig.requireCorners.get().booleanValue()) {
            if (!PortalShape.validateCorners(world, done, frame, corners, stabilizers, energyCells, targetCells, axis)) {
                return null;
            }
        } else {
            PortalShape.collectCorners(world, done, frame, corners, stabilizers, energyCells, targetCells, axis);
        }
        if (stabilizers.size() == 0) {
            return null;
        }
        return new PortalShape(axis, done, frame, stabilizers, energyCells, targetCells);
    }

    private static void collectCorners(IBlockReader world, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> corners, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, Direction.Axis axis) {
        BlockPos dir1pos = axis == Direction.Axis.Y ? BlockPos.field_177992_a.func_177974_f() : BlockPos.field_177992_a.func_177984_a();
        BlockPos dir1neg = axis == Direction.Axis.Y ? BlockPos.field_177992_a.func_177976_e() : BlockPos.field_177992_a.func_177977_b();
        BlockPos dir2pos = axis == Direction.Axis.Z ? BlockPos.field_177992_a.func_177974_f() : BlockPos.field_177992_a.func_177978_c();
        BlockPos dir2neg = axis == Direction.Axis.Z ? BlockPos.field_177992_a.func_177976_e() : BlockPos.field_177992_a.func_177968_d();
        for (BlockPos corner : corners) {
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos);
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg);
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos);
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg);
        }
    }

    private static boolean validateCorners(IBlockReader world, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> corners, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, Direction.Axis axis) {
        BlockPos dir1pos = axis == Direction.Axis.Y ? BlockPos.field_177992_a.func_177974_f() : BlockPos.field_177992_a.func_177984_a();
        BlockPos dir1neg = axis == Direction.Axis.Y ? BlockPos.field_177992_a.func_177976_e() : BlockPos.field_177992_a.func_177977_b();
        BlockPos dir2pos = axis == Direction.Axis.Z ? BlockPos.field_177992_a.func_177974_f() : BlockPos.field_177992_a.func_177978_c();
        BlockPos dir2neg = axis == Direction.Axis.Z ? BlockPos.field_177992_a.func_177976_e() : BlockPos.field_177992_a.func_177968_d();
        for (BlockPos corner : corners) {
            if (!PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos)) {
                return false;
            }
            if (!PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg)) {
                return false;
            }
            if (!PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos)) {
                return false;
            }
            if (PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectCorner(IBlockReader world, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, BlockPos corner, BlockPos dir1, BlockPos dir2) {
        if (frame.contains(corner.func_177971_a((Vector3i)dir1)) && frame.contains(corner.func_177971_a((Vector3i)dir2))) {
            BlockPos pos = corner.func_177971_a((Vector3i)dir1).func_177971_a((Vector3i)dir2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IPortalGroupTile ? ((IPortalGroupTile)tile).hasGroup() : !area.contains(pos)) {
                return false;
            }
            if (!frame.contains(pos)) {
                frame.add(pos);
                if (tile instanceof StabilizerTile) {
                    stabilizers.add(pos);
                }
                if (tile instanceof IEnergyCellTile) {
                    energyCells.add(pos);
                }
                if (tile instanceof ITargetCellTile) {
                    targetCells.add(pos);
                }
            }
        }
        return true;
    }

    public PortalShape(Direction.Axis axis, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells) {
        this.axis = axis;
        this.area.addAll(area);
        this.frame.addAll(frame);
        this.stabilizers.addAll(stabilizers);
        this.energyCells.addAll(energyCells);
        this.targetCells.addAll(targetCells);
        double span = 0.0;
        int minX = frame.get(0).func_177958_n();
        int minY = frame.get(0).func_177956_o();
        int minZ = frame.get(0).func_177952_p();
        int maxX = frame.get(0).func_177958_n();
        int maxY = frame.get(0).func_177956_o();
        int maxZ = frame.get(0).func_177952_p();
        for (int i = 0; i < frame.size(); ++i) {
            BlockPos pos1 = frame.get(i);
            for (int j = i + 1; j < frame.size(); ++j) {
                BlockPos pos2 = frame.get(j);
                double distance = pos1.func_177951_i((Vector3i)pos2);
                if (!(distance > span)) continue;
                span = distance;
            }
            if (pos1.func_177958_n() < minX) {
                minX = pos1.func_177958_n();
            }
            if (pos1.func_177956_o() < minY) {
                minY = pos1.func_177956_o();
            }
            if (pos1.func_177952_p() < minZ) {
                minZ = pos1.func_177952_p();
            }
            if (pos1.func_177958_n() > maxX) {
                maxX = pos1.func_177958_n();
            }
            if (pos1.func_177956_o() > maxY) {
                maxY = pos1.func_177956_o();
            }
            if (pos1.func_177952_p() <= maxZ) continue;
            maxZ = pos1.func_177952_p();
        }
        this.span = Math.sqrt(span);
        this.minCorner = new BlockPos(minX, minY, minZ);
        this.maxCorner = new BlockPos(maxX, maxY, maxZ);
    }

    public PortalShape(CompoundNBT tag) {
        this.axis = Enum.valueOf(Direction.Axis.class, tag.func_74779_i("axis"));
        CompoundNBT areaTag = tag.func_74775_l("area");
        for (Object key : areaTag.func_150296_c()) {
            CompoundNBT pos = areaTag.func_74775_l((String)key);
            this.area.add(new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z")));
        }
        CompoundNBT frameTag = tag.func_74775_l("frame");
        for (Object key : frameTag.func_150296_c()) {
            CompoundNBT pos = frameTag.func_74775_l((String)key);
            this.frame.add(new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z")));
        }
        CompoundNBT stabilizerTag = tag.func_74775_l("stabilizers");
        for (Object key : stabilizerTag.func_150296_c()) {
            CompoundNBT pos = stabilizerTag.func_74775_l((String)key);
            this.stabilizers.add(new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z")));
        }
        CompoundNBT energyCellsTag = tag.func_74775_l("energyCells");
        for (String key : energyCellsTag.func_150296_c()) {
            CompoundNBT pos = energyCellsTag.func_74775_l(key);
            this.energyCells.add(new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z")));
        }
        CompoundNBT targetCellsTag = tag.func_74775_l("targetCells");
        for (String key : targetCellsTag.func_150296_c()) {
            CompoundNBT pos = targetCellsTag.func_74775_l(key);
            this.targetCells.add(new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z")));
        }
        this.span = tag.func_74769_h("span");
        this.minCorner = new BlockPos(tag.func_74762_e("minCornerX"), tag.func_74762_e("minCornerY"), tag.func_74762_e("minCornerZ"));
        this.maxCorner = new BlockPos(tag.func_74762_e("maxCornerX"), tag.func_74762_e("maxCornerY"), tag.func_74762_e("maxCornerZ"));
    }

    public void createPortals(World world, DyeColor color) {
        if (color == null) {
            color = DyeColor.values()[new Random().nextInt(DyeColor.values().length)];
        }
        for (BlockPos pos : this.area) {
            if (world.func_180495_p(pos).func_177230_c() instanceof PortalBlock && world.func_180495_p(pos).func_177229_b(PortalBlock.AXIS_PROPERTY) == this.axis && world.func_180495_p(pos).func_177229_b(PortalBlock.COLOR_PROPERTY) == color) continue;
            world.func_175656_a(pos, (BlockState)((BlockState)Wormhole.portal.func_176223_P().func_206870_a(PortalBlock.AXIS_PROPERTY, (Comparable)this.axis)).func_206870_a(PortalBlock.COLOR_PROPERTY, (Comparable)color));
        }
    }

    public void destroyPortals(World world) {
        for (BlockPos pos : this.area) {
            if (!(world.func_180495_p(pos).func_177230_c() instanceof PortalBlock)) continue;
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean validateFrame(IBlockReader world) {
        for (BlockPos pos : this.frame) {
            if (world.func_180495_p(pos).func_177230_c() instanceof IPortalGroupTile) continue;
            return false;
        }
        return true;
    }

    public boolean validatePortal(IBlockReader world) {
        for (BlockPos pos : this.area) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof PortalBlock && state.func_177229_b(PortalBlock.AXIS_PROPERTY) == this.axis || state.func_177230_c() == Blocks.field_150350_a) continue;
            return false;
        }
        return true;
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("axis", this.axis.name());
        CompoundNBT areaTag = new CompoundNBT();
        for (int i = 0; i < this.area.size(); ++i) {
            CompoundNBT pos = new CompoundNBT();
            pos.func_74768_a("x", this.area.get(i).func_177958_n());
            pos.func_74768_a("y", this.area.get(i).func_177956_o());
            pos.func_74768_a("z", this.area.get(i).func_177952_p());
            areaTag.func_218657_a("" + i, (INBT)pos);
        }
        tag.func_218657_a("area", (INBT)areaTag);
        CompoundNBT frameTag = new CompoundNBT();
        for (int i = 0; i < this.frame.size(); ++i) {
            CompoundNBT pos = new CompoundNBT();
            pos.func_74768_a("x", this.frame.get(i).func_177958_n());
            pos.func_74768_a("y", this.frame.get(i).func_177956_o());
            pos.func_74768_a("z", this.frame.get(i).func_177952_p());
            frameTag.func_218657_a("" + i, (INBT)pos);
        }
        tag.func_218657_a("frame", (INBT)frameTag);
        CompoundNBT stabilizerTag = new CompoundNBT();
        for (int i = 0; i < this.stabilizers.size(); ++i) {
            CompoundNBT pos = new CompoundNBT();
            pos.func_74768_a("x", this.stabilizers.get(i).func_177958_n());
            pos.func_74768_a("y", this.stabilizers.get(i).func_177956_o());
            pos.func_74768_a("z", this.stabilizers.get(i).func_177952_p());
            stabilizerTag.func_218657_a("" + i, (INBT)pos);
        }
        tag.func_218657_a("stabilizers", (INBT)stabilizerTag);
        CompoundNBT energyCellsTag = new CompoundNBT();
        for (int i = 0; i < this.energyCells.size(); ++i) {
            CompoundNBT pos = new CompoundNBT();
            pos.func_74768_a("x", this.energyCells.get(i).func_177958_n());
            pos.func_74768_a("y", this.energyCells.get(i).func_177956_o());
            pos.func_74768_a("z", this.energyCells.get(i).func_177952_p());
            energyCellsTag.func_218657_a("" + i, (INBT)pos);
        }
        tag.func_218657_a("energyCells", (INBT)energyCellsTag);
        CompoundNBT targetCellsTag = new CompoundNBT();
        for (int i = 0; i < this.targetCells.size(); ++i) {
            CompoundNBT pos = new CompoundNBT();
            pos.func_74768_a("x", this.targetCells.get(i).func_177958_n());
            pos.func_74768_a("y", this.targetCells.get(i).func_177956_o());
            pos.func_74768_a("z", this.targetCells.get(i).func_177952_p());
            targetCellsTag.func_218657_a("" + i, (INBT)pos);
        }
        tag.func_218657_a("targetCells", (INBT)targetCellsTag);
        tag.func_74780_a("span", this.span);
        tag.func_74768_a("minCornerX", this.minCorner.func_177958_n());
        tag.func_74768_a("minCornerY", this.minCorner.func_177956_o());
        tag.func_74768_a("minCornerZ", this.minCorner.func_177952_p());
        tag.func_74768_a("maxCornerX", this.maxCorner.func_177958_n());
        tag.func_74768_a("maxCornerY", this.maxCorner.func_177956_o());
        tag.func_74768_a("maxCornerZ", this.maxCorner.func_177952_p());
        return tag;
    }

    public static PortalShape read(CompoundNBT tag) {
        return new PortalShape(tag);
    }

    static {
        DIRECT_OFFSETS.put(Direction.Axis.X, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.field_177992_a.func_177984_a(), BlockPos.field_177992_a.func_177977_b(), BlockPos.field_177992_a.func_177978_c(), BlockPos.field_177992_a.func_177968_d()}));
        DIRECT_OFFSETS.put(Direction.Axis.Y, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.field_177992_a.func_177978_c(), BlockPos.field_177992_a.func_177974_f(), BlockPos.field_177992_a.func_177968_d(), BlockPos.field_177992_a.func_177976_e()}));
        DIRECT_OFFSETS.put(Direction.Axis.Z, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.field_177992_a.func_177984_a(), BlockPos.field_177992_a.func_177977_b(), BlockPos.field_177992_a.func_177974_f(), BlockPos.field_177992_a.func_177976_e()}));
        INDIRECT_OFFSETS.put(Direction.Axis.X, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.field_177992_a.func_177984_a().func_177978_c(), BlockPos.field_177992_a.func_177984_a().func_177968_d(), BlockPos.field_177992_a.func_177977_b().func_177978_c(), BlockPos.field_177992_a.func_177977_b().func_177968_d()}));
        INDIRECT_OFFSETS.put(Direction.Axis.Y, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.field_177992_a.func_177978_c().func_177974_f(), BlockPos.field_177992_a.func_177978_c().func_177976_e(), BlockPos.field_177992_a.func_177968_d().func_177974_f(), BlockPos.field_177992_a.func_177968_d().func_177976_e()}));
        INDIRECT_OFFSETS.put(Direction.Axis.Z, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.field_177992_a.func_177984_a().func_177974_f(), BlockPos.field_177992_a.func_177984_a().func_177976_e(), BlockPos.field_177992_a.func_177977_b().func_177974_f(), BlockPos.field_177992_a.func_177977_b().func_177976_e()}));
        for (Direction.Axis axis : Direction.Axis.values()) {
            ArrayList pos = new ArrayList();
            pos.addAll(DIRECT_OFFSETS.get(axis));
            pos.addAll(INDIRECT_OFFSETS.get(axis));
            ALL_OFFSETS.put(axis, pos);
        }
    }
}

