/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.WormholeBlock;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.generator.CoalGeneratorTile;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class CoalGeneratorBlock
extends WormholeBlock {
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.0625, (double)0.875, (double)0.75, (double)0.8125), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.8125, (double)0.4375, (double)0.4375, (double)0.9375), VoxelShapes.func_197873_a((double)0.25, (double)0.4375, (double)0.8125, (double)0.375, (double)0.625, (double)0.875), VoxelShapes.func_197873_a((double)0.5625, (double)0.0, (double)0.8125, (double)0.8125, (double)0.4375, (double)0.9375), VoxelShapes.func_197873_a((double)0.625, (double)0.4375, (double)0.8125, (double)0.75, (double)0.625, (double)0.875)});
    private static final VoxelShape[] SHAPES = new VoxelShape[4];
    public static final BooleanProperty LIT;
    public static final EnumProperty<Direction> FACING;

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - from.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }

    public CoalGeneratorBlock() {
        super("coal_generator", true, AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151670_w).func_200947_a(SoundType.field_185852_e).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a(FACING, (Comparable)Direction.NORTH));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return null;
                }

                public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
                    return new CoalGeneratorContainer(windowId, player, pos);
                }
            }, (BlockPos)pos);
        }
        return ActionResultType.CONSUME;
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int range = 2 * WormholeConfig.coalGeneratorRange.get() + 1;
        tooltip.add((ITextComponent)new TranslationTextComponent("wormhole.coal_generator.info", new Object[]{range, EnergyFormat.formatEnergyPerTick(WormholeConfig.coalGeneratorPower.get())}).func_240699_a_(TextFormatting.AQUA));
        CompoundNBT tag = stack.func_196082_o().func_74764_b("tileData") ? stack.func_196082_o().func_74775_l("tileData") : null;
        int energy = tag == null || tag.isEmpty() || !tag.func_74764_b("energy") ? 0 : tag.func_74762_e("energy");
        tooltip.add((ITextComponent)new StringTextComponent(EnergyFormat.formatCapacity(energy, WormholeConfig.coalGeneratorCapacity.get())).func_240699_a_(TextFormatting.YELLOW));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b(FACING)).func_176736_b()];
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 8 : 0;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CoalGeneratorTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, FACING});
    }

    static {
        CoalGeneratorBlock.SHAPES[Direction.NORTH.func_176736_b()] = SHAPE;
        CoalGeneratorBlock.SHAPES[Direction.EAST.func_176736_b()] = CoalGeneratorBlock.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
        CoalGeneratorBlock.SHAPES[Direction.SOUTH.func_176736_b()] = CoalGeneratorBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
        CoalGeneratorBlock.SHAPES[Direction.WEST.func_176736_b()] = CoalGeneratorBlock.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
        LIT = BooleanProperty.func_177716_a((String)"lit");
        FACING = HorizontalBlock.field_185512_D;
    }
}

