/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.wormhole.energycell.EnergyCellTile;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class EnergyCellTileRenderer
extends TileEntityRenderer<EnergyCellTile> {
    public static final ResourceLocation[] ENERGY_CELL_MODELS = new ResourceLocation[16];

    public EnergyCellTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(EnergyCellTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        int texture = tile.getMaxEnergyStored(true) > 0 ? (int)Math.ceil((double)tile.getEnergyStored(true) / (double)tile.getMaxEnergyStored(true) * 15.0) : 0;
        IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(ENERGY_CELL_MODELS[texture]);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel((IBlockDisplayReader)tile.func_145831_w(), model, tile.func_195044_w(), tile.func_174877_v(), matrixStack, buffer.getBuffer(RenderType.func_228639_c_()), true, new Random(), 42L, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
    }

    public static IBakedModel getModelForTile(EnergyCellTile tile) {
        int texture = tile.getMaxEnergyStored(true) > 0 ? (int)Math.ceil((double)tile.getEnergyStored(true) / (double)tile.getMaxEnergyStored(true) * 15.0) : 0;
        return Minecraft.func_71410_x().func_209506_al().getModel(ENERGY_CELL_MODELS[texture]);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            EnergyCellTileRenderer.ENERGY_CELL_MODELS[i] = new ResourceLocation("wormhole", "block/energy_cell/basic/basic_energy_cell_" + i);
        }
    }
}

