/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.List;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class EnergyCellBlock
extends PortalGroupBlock {
    private final EnergyCellType type;

    public EnergyCellBlock(EnergyCellType type) {
        super(type.getRegistryName(), type::createTile);
        this.type = type;
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag;
        tooltip.add((ITextComponent)new TranslationTextComponent("wormhole.energy_cell.info").func_240699_a_(TextFormatting.AQUA));
        CompoundNBT compoundNBT = tag = stack.func_196082_o().func_74764_b("tileData") ? stack.func_196082_o().func_74775_l("tileData") : null;
        int energy = this.type == EnergyCellType.CREATIVE ? this.type.getCapacity() : (tag == null || tag.isEmpty() || !tag.func_74764_b("energy") ? 0 : tag.func_74762_e("energy"));
        int capacity = this.type.getCapacity();
        if (capacity > 0) {
            tooltip.add((ITextComponent)new StringTextComponent(EnergyFormat.formatCapacity(energy, capacity)).func_240699_a_(TextFormatting.YELLOW));
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return this.type == EnergyCellType.CREATIVE ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }
}

