/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.NBTRecipe;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.PortalTile;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.StabilizerTile;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellTile;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.generator.CoalGeneratorTile;
import com.supermartijn642.wormhole.packet.PortalGroupPacket;
import com.supermartijn642.wormhole.packet.TargetDevicePacket;
import com.supermartijn642.wormhole.packet.UpdateGroupPacket;
import com.supermartijn642.wormhole.packet.UpdateGroupsPacket;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.packets.PortalActivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalAddTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalClearTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalColorTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalDeactivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalMoveTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalNameTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalSelectTargetPacket;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceAddPacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceMovePacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceNamePacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceRemovePacket;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="wormhole")
public class Wormhole {
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("wormhole", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final IRecipeSerializer<NBTRecipe> NBT_RECIPE_SERIALIZER = new NBTRecipe.Serializer();
    public static final ItemGroup ITEM_GROUP = new ItemGroup("wormhole"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)advanced_target_device);
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            items.sort(Comparator.comparing(a -> a.func_200301_q().getString()));
        }
    };
    @ObjectHolder(value="wormhole:portal_frame")
    public static Block portal_frame;
    @ObjectHolder(value="wormhole:portal")
    public static Block portal;
    @ObjectHolder(value="wormhole:portal_stabilizer")
    public static Block portal_stabilizer;
    @ObjectHolder(value="wormhole:basic_energy_cell")
    public static EnergyCellBlock basic_energy_cell;
    @ObjectHolder(value="wormhole:advanced_energy_cell")
    public static EnergyCellBlock advanced_energy_cell;
    @ObjectHolder(value="wormhole:creative_energy_cell")
    public static EnergyCellBlock creative_energy_cell;
    @ObjectHolder(value="wormhole:target_device")
    public static Item target_device;
    @ObjectHolder(value="wormhole:advanced_target_device")
    public static Item advanced_target_device;
    @ObjectHolder(value="wormhole:basic_target_cell")
    public static TargetCellBlock basic_target_cell;
    @ObjectHolder(value="wormhole:advanced_target_cell")
    public static TargetCellBlock advanced_target_cell;
    @ObjectHolder(value="wormhole:coal_generator")
    public static CoalGeneratorBlock coal_generator;
    @ObjectHolder(value="wormhole:portal_frame_tile")
    public static TileEntityType<?> portal_frame_tile;
    @ObjectHolder(value="wormhole:portal_tile")
    public static TileEntityType<?> portal_tile;
    @ObjectHolder(value="wormhole:stabilizer_tile")
    public static TileEntityType<?> stabilizer_tile;
    @ObjectHolder(value="wormhole:basic_energy_cell_tile")
    public static TileEntityType<EnergyCellTile> basic_energy_cell_tile;
    @ObjectHolder(value="wormhole:advanced_energy_cell_tile")
    public static TileEntityType<EnergyCellTile> advanced_energy_cell_tile;
    @ObjectHolder(value="wormhole:creative_energy_cell_tile")
    public static TileEntityType<EnergyCellTile> creative_energy_cell_tile;
    @ObjectHolder(value="wormhole:basic_target_cell_tile")
    public static TileEntityType<TargetCellTile> basic_target_cell_tile;
    @ObjectHolder(value="wormhole:advanced_target_cell_tile")
    public static TileEntityType<TargetCellTile> advanced_target_cell_tile;
    @ObjectHolder(value="wormhole:coal_generator_tile")
    public static TileEntityType<CoalGeneratorTile> coal_generator_tile;
    @ObjectHolder(value="wormhole:coal_generator_container")
    public static ContainerType<CoalGeneratorContainer> coal_generator_container;

    public Wormhole() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        CHANNEL.registerMessage(0, TargetDeviceAddPacket.class, TargetDeviceAddPacket::encode, TargetDeviceAddPacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(1, TargetDeviceMovePacket.class, TargetDeviceMovePacket::encode, TargetDeviceMovePacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(2, TargetDeviceRemovePacket.class, TargetDeviceRemovePacket::encode, TargetDeviceRemovePacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(3, TargetDeviceNamePacket.class, TargetDeviceNamePacket::encode, TargetDeviceNamePacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(4, PortalAddTargetPacket.class, PortalAddTargetPacket::encode, PortalAddTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(5, PortalClearTargetPacket.class, PortalClearTargetPacket::encode, PortalClearTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(6, PortalMoveTargetPacket.class, PortalMoveTargetPacket::encode, PortalMoveTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(7, PortalNameTargetPacket.class, PortalNameTargetPacket::encode, PortalNameTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(8, PortalSelectTargetPacket.class, PortalSelectTargetPacket::encode, PortalSelectTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(9, UpdateGroupPacket.class, UpdateGroupPacket::encode, UpdateGroupPacket::new, UpdateGroupPacket::handle);
        CHANNEL.registerMessage(10, UpdateGroupsPacket.class, UpdateGroupsPacket::encode, UpdateGroupsPacket::new, UpdateGroupsPacket::handle);
        CHANNEL.registerMessage(11, PortalColorTargetPacket.class, PortalColorTargetPacket::encode, PortalColorTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(12, PortalActivatePacket.class, PortalGroupPacket::encode, PortalActivatePacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(13, PortalDeactivatePacket.class, PortalGroupPacket::encode, PortalDeactivatePacket::new, PortalGroupPacket::handle);
    }

    public void init(FMLCommonSetupEvent e) {
        PortalGroupCapability.register();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            e.getRegistry().register((IForgeRegistryEntry)new PortalGroupBlock("portal_frame", () -> new PortalGroupTile(portal_frame_tile)));
            e.getRegistry().register((IForgeRegistryEntry)new PortalBlock());
            e.getRegistry().register((IForgeRegistryEntry)new StabilizerBlock());
            for (EnergyCellType energyCellType : EnergyCellType.values()) {
                e.getRegistry().register((IForgeRegistryEntry)new EnergyCellBlock(energyCellType));
            }
            for (Enum enum_ : TargetCellType.values()) {
                e.getRegistry().register((IForgeRegistryEntry)new TargetCellBlock((TargetCellType)enum_));
            }
            e.getRegistry().register((IForgeRegistryEntry)new CoalGeneratorBlock());
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> e) {
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new PortalGroupTile(portal_frame_tile), (Block[])new Block[]{portal_frame}).func_206865_a(null).setRegistryName("portal_frame_tile"));
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(PortalTile::new, (Block[])new Block[]{portal}).func_206865_a(null).setRegistryName("portal_tile"));
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(StabilizerTile::new, (Block[])new Block[]{portal_stabilizer}).func_206865_a(null).setRegistryName("stabilizer_tile"));
            for (EnergyCellType energyCellType : EnergyCellType.values()) {
                e.getRegistry().register(TileEntityType.Builder.func_223042_a(energyCellType::createTile, (Block[])new Block[]{energyCellType.getBlock()}).func_206865_a(null).setRegistryName(energyCellType.getRegistryName() + "_tile"));
            }
            for (Enum enum_ : TargetCellType.values()) {
                e.getRegistry().register(TileEntityType.Builder.func_223042_a(((TargetCellType)enum_)::createTile, (Block[])new Block[]{((TargetCellType)enum_).getBlock()}).func_206865_a(null).setRegistryName(((TargetCellType)enum_).getRegistryName() + "_tile"));
            }
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(CoalGeneratorTile::new, (Block[])new Block[]{coal_generator}).func_206865_a(null).setRegistryName("coal_generator_tile"));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            e.getRegistry().register(new BlockItem(portal_frame, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(portal_frame.getRegistryName()));
            e.getRegistry().register(new BlockItem(portal, new Item.Properties()).setRegistryName(portal.getRegistryName()));
            e.getRegistry().register(new BlockItem(portal_stabilizer, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(portal_stabilizer.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)basic_energy_cell, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(basic_energy_cell.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)advanced_energy_cell, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(advanced_energy_cell.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)creative_energy_cell, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(creative_energy_cell.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)basic_target_cell, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(basic_target_cell.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)advanced_target_cell, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(advanced_target_cell.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)coal_generator, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName(coal_generator.getRegistryName()));
            e.getRegistry().register((IForgeRegistryEntry)new TargetDeviceItem("target_device", WormholeConfig.basicDeviceTargetCount::get));
            e.getRegistry().register((IForgeRegistryEntry)new TargetDeviceItem("advanced_target_device", WormholeConfig.advancedDeviceTargetCount::get));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> e) {
            e.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new CoalGeneratorContainer(windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("coal_generator_container"));
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<IRecipeSerializer<?>> e) {
            e.getRegistry().register((IForgeRegistryEntry)NBT_RECIPE_SERIALIZER.setRegistryName(new ResourceLocation("wormhole", "nbtrecipe")));
        }
    }
}

