/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.PortalTile;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PortalBlock
extends PortalGroupBlock {
    private static final VoxelShape SHAPE_X = VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_Y = VoxelShapes.func_197873_a((double)0.0, (double)0.375, (double)0.0, (double)1.0, (double)0.625, (double)1.0);
    private static final VoxelShape SHAPE_Z = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
    public static final EnumProperty<Direction.Axis> AXIS_PROPERTY = EnumProperty.func_177706_a((String)"axis", Direction.Axis.class, (Enum[])Direction.Axis.values());
    public static final EnumProperty<DyeColor> COLOR_PROPERTY = EnumProperty.func_177706_a((String)"color", DyeColor.class, (Enum[])DyeColor.values());

    public PortalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(o -> 11).func_222380_e(), "portal", PortalTile::new);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(AXIS_PROPERTY, (Comparable)Direction.Axis.X)).func_206870_a(COLOR_PROPERTY, (Comparable)DyeColor.WHITE));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PortalTile) {
            return ((PortalTile)tile).activate(player, handIn) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PortalTile) {
            ((PortalTile)tile).teleport(entityIn);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS_PROPERTY, COLOR_PROPERTY});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS_PROPERTY);
        return axis == Direction.Axis.X ? SHAPE_X : (axis == Direction.Axis.Y ? SHAPE_Y : (axis == Direction.Axis.Z ? SHAPE_Z : VoxelShapes.func_197880_a()));
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PortalTile && !((PortalTile)tile).hasGroup()) {
            tile.func_145831_w().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }
}

