/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.energycell.EnergyCellTileRenderer;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.generator.CoalGeneratorScreen;
import com.supermartijn642.wormhole.generator.GeneratorTile;
import com.supermartijn642.wormhole.portal.screen.PortalOverviewScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetColorScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetScreen;
import com.supermartijn642.wormhole.targetcell.TargetCellTileRenderer;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceScreen;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent e) {
        RenderTypeLookup.setRenderLayer((Block)Wormhole.portal, (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer(Wormhole.basic_energy_cell_tile, EnergyCellTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(Wormhole.advanced_energy_cell_tile, EnergyCellTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(Wormhole.basic_target_cell_tile, TargetCellTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(Wormhole.advanced_target_cell_tile, TargetCellTileRenderer::new);
        ClientProxy.registerScreen();
    }

    @SubscribeEvent
    public static void modelRegistry(ModelRegistryEvent e) {
        for (ResourceLocation model : EnergyCellTileRenderer.ENERGY_CELL_MODELS) {
            ModelLoader.addSpecialModel((ResourceLocation)model);
        }
        for (ResourceLocation model : TargetCellTileRenderer.BASIC_TARGET_CELL_MODELS) {
            ModelLoader.addSpecialModel((ResourceLocation)model);
        }
        for (ResourceLocation model : TargetCellTileRenderer.ADVANCED_TARGET_CELL_MODELS) {
            ModelLoader.addSpecialModel((ResourceLocation)model);
        }
    }

    public static void registerScreen() {
        ScreenManager.func_216911_a(Wormhole.coal_generator_container, (container, player, title) -> new CoalGeneratorScreen((CoalGeneratorContainer)container, player));
    }

    public static void openTargetDeviceScreen(Hand hand, BlockPos pos, float yaw) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TargetDeviceScreen(ClientProxy.getPlayer(), hand, pos, yaw));
    }

    public static void openPortalTargetScreen(BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PortalTargetScreen(pos, ClientProxy.getPlayer()));
    }

    public static void openPortalTargetScreen(BlockPos pos, int scrollOffset, int selectedPortalTarget, int selectedDeviceTarget) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PortalTargetScreen(pos, ClientProxy.getPlayer(), scrollOffset, selectedPortalTarget, selectedDeviceTarget));
    }

    public static void openPortalTargetColorScreen(BlockPos pos, int targetIndex, Runnable returnScreen) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PortalTargetColorScreen(pos, targetIndex, returnScreen));
    }

    public static void openPortalOverviewScreen(BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PortalOverviewScreen(pos));
    }

    public static PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawHighlightEvent.HighlightBlock e) {
            World world = ClientProxy.getWorld();
            TileEntity tile = world.func_175625_s(e.getTarget().func_216350_a());
            if (tile instanceof GeneratorTile) {
                VoxelShape shape;
                MatrixStack matrixStack = e.getMatrix();
                matrixStack.func_227860_a_();
                Vector3d playerPos = Minecraft.func_71410_x().field_71439_g.func_174824_e(e.getPartialTicks());
                matrixStack.func_227861_a_(-playerPos.field_72450_a, -playerPos.field_72448_b, -playerPos.field_72449_c);
                IVertexBuilder builder = e.getBuffers().getBuffer(RenderType.func_228659_m_());
                for (BlockPos pos : ((GeneratorTile)tile).getChargingPortalBlocks()) {
                    shape = world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos);
                    Events.drawShape(e.getMatrix(), builder, shape, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.25882354f, 0.42352942f, 0.9607843f, 1.0f);
                }
                for (BlockPos pos : ((GeneratorTile)tile).getChargingEnergyBlocks()) {
                    shape = world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos);
                    Events.drawShape(e.getMatrix(), builder, shape, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.9490196f, 0.13333334f, 0.13333334f, 1.0f);
                }
                matrixStack.func_227865_b_();
            }
        }

        private static void drawShape(MatrixStack matrixStackIn, IVertexBuilder bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            shapeIn.func_197754_a((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
                bufferIn.func_227888_a_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
                bufferIn.func_227888_a_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            });
        }
    }
}

