/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.building.view.PositionalBuildView;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.compression.DataCompressor;
import com.direwolf20.buildinggadgets.common.util.compression.DataDecompressor;
import com.direwolf20.buildinggadgets.common.util.tools.MathUtils;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public final class Template {
    private final ImmutableMap<BlockPos, BlockData> map;
    private TemplateHeader header;
    private boolean isNormalized;

    public static Template deserialize(CompoundNBT nbt, @Nullable TemplateHeader externalHeader, boolean persisted) {
        ListNBT posList = nbt.func_150295_c("pos", 4);
        TemplateHeader.Builder header = TemplateHeader.builderFromNBT(nbt.func_74775_l("header"));
        if (externalHeader != null) {
            header = header.name(externalHeader.getName()).author(externalHeader.getAuthor());
        }
        DataDecompressor<ITileDataSerializer> serializerDecompressor = persisted ? new DataDecompressor<ITileDataSerializer>(nbt.func_150295_c("serializer", 8), inbt -> RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), inbt.func_150285_a_()), value -> SerialisationSupport.dummyDataSerializer()) : null;
        DataDecompressor<BlockData> dataDecompressor = new DataDecompressor<BlockData>(nbt.func_150295_c("data", 10), inbt -> persisted ? BlockData.tryDeserialize((CompoundNBT)inbt, serializerDecompressor, true) : BlockData.tryDeserialize((CompoundNBT)inbt, false), value -> BlockData.AIR);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (INBT inbt2 : posList) {
            LongNBT longNBT = (LongNBT)inbt2;
            BlockPos pos = MathUtils.posFromLong(longNBT.func_150291_c());
            BlockData data = dataDecompressor.apply(MathUtils.readStateId(longNBT.func_150291_c()));
            mapBuilder.put((Object)pos, (Object)data);
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), header.build());
    }

    public Template(ImmutableMap<BlockPos, BlockData> map, TemplateHeader header) {
        this(map, header, false);
    }

    private Template(ImmutableMap<BlockPos, BlockData> map, TemplateHeader header, boolean isNormalized) {
        this.map = map;
        this.header = header;
        this.isNormalized = isNormalized;
    }

    public Template() {
        this((ImmutableMap<BlockPos, BlockData>)ImmutableMap.of(), TemplateHeader.builder(Region.singleZero()).build());
    }

    public TemplateHeader getHeaderAndForceMaterials(BuildContext context) {
        if (this.header.getRequiredItems() == null) {
            MaterialList materialList = CommonUtils.estimateRequiredItems(this.createViewInContext(context), context, context.getPlayer() != null ? context.getPlayer().func_213303_ch().func_72441_c(0.0, (double)context.getPlayer().func_70047_e(), 0.0) : null);
            this.header = TemplateHeader.builderOf(this.header).requiredItems(materialList).build();
        }
        return this.getHeader();
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public IBuildView createViewInContext(BuildContext context) {
        return PositionalBuildView.createUnsafe(context, this.map, this.header.getBoundingBox());
    }

    public CompoundNBT serialize(boolean persisted) {
        if (!this.isNormalized) {
            return this.normalize().serialize(persisted);
        }
        CompoundNBT res = new CompoundNBT();
        ListNBT posList = new ListNBT();
        DataCompressor<Object> blockDataCompressor = new DataCompressor<Object>();
        DataCompressor<ITileDataSerializer> dataSerializerCompressor = new DataCompressor<ITileDataSerializer>();
        for (Map.Entry entry : this.map.entrySet()) {
            long posEntry = MathUtils.includeStateId(MathUtils.posToLong((BlockPos)entry.getKey()), blockDataCompressor.applyAsInt(entry.getValue()));
            posList.add((Object)LongNBT.func_229698_a_((long)posEntry));
        }
        ListNBT dataList = blockDataCompressor.write(d -> persisted ? d.serialize(dataSerializerCompressor, true) : d.serialize(false));
        ListNBT serializerList = persisted ? dataSerializerCompressor.write(s -> StringNBT.func_229705_a_((String)s.getRegistryName().toString())) : null;
        res.func_218657_a("data", (INBT)dataList);
        res.func_218657_a("pos", (INBT)posList);
        res.func_218657_a("header", (INBT)this.header.toNBT(persisted));
        if (persisted) {
            res.func_218657_a("serializer", (INBT)serializerList);
        }
        return res;
    }

    public Template rotate(Rotation rotation) {
        return this.rotate(Direction.Axis.Y, rotation);
    }

    public Template rotate(Direction.Axis axis, Rotation rotation) {
        if (this.map.isEmpty()) {
            return this;
        }
        int[][] matrix = MathUtils.rotationMatrixFor(axis, rotation);
        rotation = axis == Direction.Axis.Y ? rotation : Rotation.NONE;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Region.Builder regionBuilder = Region.enclosingBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            BlockPos newPos = MathUtils.matrixMul(matrix, (BlockPos)entry.getKey());
            mapBuilder.put((Object)newPos, (Object)((BlockData)entry.getValue()).rotate(rotation));
            regionBuilder.enclose((Vector3i)newPos);
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), TemplateHeader.builderOf(this.header, regionBuilder.build()).build()).normalize();
    }

    public Template mirror(Direction.Axis axis) {
        Mirror mirror;
        int xFac = 1;
        int zFac = 1;
        switch (axis) {
            case X: {
                mirror = Mirror.LEFT_RIGHT;
                zFac = -1;
                break;
            }
            case Z: {
                mirror = Mirror.FRONT_BACK;
                xFac = -1;
                break;
            }
            default: {
                mirror = Mirror.NONE;
            }
        }
        Region.Builder regionBuilder = Region.enclosingBuilder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            BlockPos newPos = new BlockPos(((BlockPos)entry.getKey()).func_177958_n() * xFac, ((BlockPos)entry.getKey()).func_177956_o(), ((BlockPos)entry.getKey()).func_177952_p() * zFac);
            mapBuilder.put((Object)newPos, (Object)((BlockData)entry.getValue()).mirror(mirror));
            regionBuilder.enclose((Vector3i)newPos);
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), TemplateHeader.builderOf(this.header, regionBuilder.build()).build()).normalize();
    }

    public Template replace(Function<BlockPos, Optional<BlockData>> replacements) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            mapBuilder.put(entry.getKey(), (Object)replacements.apply((BlockPos)entry.getKey()).orElse((BlockData)entry.getValue()));
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), this.header, this.isNormalized);
    }

    public Template withName(@Nullable String name) {
        return new Template(this.map, TemplateHeader.builderOf(this.header).name(name).build());
    }

    public Template withNameAndAuthor(@Nullable String name, @Nullable String author) {
        return new Template(this.map, TemplateHeader.builderOf(this.header).name(name).author(author).build());
    }

    public Template clearMaterials() {
        return new Template(this.map, TemplateHeader.builderOf(this.header).requiredItems(null).build());
    }

    public Template normalize() {
        if (this.isNormalized) {
            return this;
        }
        Region region = this.header.getBoundingBox();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            builder.put((Object)((BlockPos)entry.getKey()).func_177973_b((Vector3i)region.getMin()), entry.getValue());
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)builder.build(), TemplateHeader.builderOf(this.header, region.inverseTranslate((Vector3i)region.getMin())).build(), true);
    }
}

