/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorDescriptor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullConsumer;

public class TurbineRotorBearingEntity
extends AbstractTurbineEntity {
    private float _rotorAngle = 0.0f;
    private AxisAlignedBB _renderBoundingBox = INFINITE_EXTENT_AABB;
    private RotorDescriptor _rotorDescriptor = null;

    public TurbineRotorBearingEntity() {
        super((TileEntityType)Content.TileEntityTypes.TURBINE_ROTORBEARING.get());
    }

    public Direction getRotorDirection() {
        PartPosition partPosition = this.getPartPosition();
        if (partPosition.isFace()) {
            return partPosition.getDirection().map(Direction::func_176734_d).orElse(Direction.UP);
        }
        return this.getOutwardFacingFromWorldPosition(Direction.DOWN).func_176734_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotorAngle() {
        return this._rotorAngle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRotorAngle(float angle) {
        this._rotorAngle = angle;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public RotorDescriptor getRotorDescriptor() {
        if (null == this._rotorDescriptor) {
            this._rotorDescriptor = this.buildRotorDescriptor();
        }
        return this._rotorDescriptor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTurbineInteriorInvisible() {
        return (Boolean)this.evalOnController(AbstractMultiblockController::isInteriorInvisible, false);
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFace()) {
            return true;
        }
        validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.turbine.invalid_bearing_position", new Object[0]);
        return false;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    @Override
    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled(controller);
        this.resetRotorDescriptor();
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.resetRotorDescriptor();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this._renderBoundingBox;
    }

    private void resetRotorDescriptor() {
        this._rotorDescriptor = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private RotorDescriptor buildRotorDescriptor() {
        return (RotorDescriptor)this.evalOnController(turbine -> (RotorDescriptor)turbine.mapBoundingBoxCoordinates((min, max) -> this.buildRotorDescriptor((MultiblockTurbine)turbine, (BlockPos)min, (BlockPos)max), null), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    private RotorDescriptor buildRotorDescriptor(MultiblockTurbine turbine, BlockPos turbineMin, BlockPos turbineMax) {
        int rotorLength;
        this._renderBoundingBox = new AxisAlignedBB(turbineMin, turbineMax);
        Direction rotorDirection = this.getRotorDirection();
        switch (rotorDirection.func_176740_k()) {
            case X: {
                rotorLength = Math.abs(turbineMax.func_177958_n() - turbineMin.func_177958_n()) - 1;
                break;
            }
            default: {
                rotorLength = Math.abs(turbineMax.func_177956_o() - turbineMin.func_177956_o()) - 1;
                break;
            }
            case Z: {
                rotorLength = Math.abs(turbineMax.func_177952_p() - turbineMin.func_177952_p()) - 1;
            }
        }
        List bladesDirections = CodeHelper.perpendicularDirections((Direction)rotorDirection);
        World world = this.getPartWorldOrFail();
        RotorDescriptor.Builder rotorBuilder = RotorDescriptor.builder(TurbineVariant.from(turbine.getVariant()), rotorDirection, rotorLength);
        BlockPos shaftPosition = this.getWorldPosition().func_177972_a(rotorDirection);
        int checkedSections = 0;
        do {
            RotorShaftState shaftState = WorldHelper.getTile((World)world, (BlockPos)shaftPosition).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> TurbineRotorComponentEntity.computeShaftState((TurbineRotorComponentEntity)((Object)te))).orElse(RotorShaftState.HIDDEN);
            BlockPos bladesPosition = shaftPosition;
            rotorBuilder.section(shaftState, (NonNullConsumer<ShaftSection.Builder>)((NonNullConsumer)sectionBuilder -> this.buildShaftSection(world, bladesPosition, bladesDirections, (ShaftSection.Builder)sectionBuilder)));
            shaftPosition = shaftPosition.func_177972_a(rotorDirection);
        } while (++checkedSections < rotorLength);
        return rotorBuilder.build();
    }

    private void buildShaftSection(World world, BlockPos shaftPosition, List<Direction> bladesDirections, ShaftSection.Builder sectionBuilder) {
        for (Direction direction : bladesDirections) {
            BlockPos bladePosition = shaftPosition.func_177972_a(direction);
            RotorBladeState state = WorldHelper.getTile((World)world, (BlockPos)bladePosition).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> (TurbineRotorComponentEntity)((Object)te)).filter(TurbineRotorComponentEntity::isBlade).map(TurbineRotorComponentEntity::computeBladeState).orElse(RotorBladeState.HIDDEN);
            if (RotorBladeState.HIDDEN == state) continue;
            short bladeLength = 1;
            while (WorldHelper.getTile((World)world, (BlockPos)(bladePosition = bladePosition.func_177972_a(direction))).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> (TurbineRotorComponentEntity)((Object)te)).map(TurbineRotorComponentEntity::isBlade).orElse(false).booleanValue()) {
                bladeLength = (short)(bladeLength + 1);
            }
            sectionBuilder.addBlade(state, bladeLength, direction);
        }
    }
}

