/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import java.util.Calendar;
import net.minecraftforge.common.ForgeConfigSpec;

public class Client {
    public final ForgeConfigSpec.BooleanValue disableReactorParticles;
    public final ForgeConfigSpec.BooleanValue disableTurbineParticles;
    public final ForgeConfigSpec.BooleanValue disableApiTooltips;
    public final ForgeConfigSpec.BooleanValue disablePatchouliTweaks;
    public final boolean isValentinesDay;

    Client(ForgeConfigSpec.Builder builder) {
        builder.comment("Client only settings").push("client");
        this.disableReactorParticles = builder.comment("If true, disables all particle effects in the Reactor.").translation("config.bigreactors.client.disablereactorparticles").define("disableReactorParticles", false);
        this.disableTurbineParticles = builder.comment("If true, disables all particle effects in the Turbine.").translation("config.bigreactors.client.disableturbineparticles").define("disableTurbineParticles", false);
        this.disableApiTooltips = builder.comment("If true, no (advanced) tooltips will be added to blocks and items that can be used inside the Reactor or Turbine or as a fuel source.").translation("config.bigreactors.client.disableapitooltips").define("disableTurbineParticles", false);
        this.disablePatchouliTweaks = builder.comment("If true, no custom Patchouli components will be added and the book will stop to work correctly. Enable this if you are having problems with newer versions of Patchouli").translation("config.bigreactors.client.disablepatchoulitweaks").define("disablePatchouliTweaks", false);
        builder.pop();
        Calendar calendar = Calendar.getInstance();
        this.isValentinesDay = calendar.get(2) == 1 && calendar.get(5) == 14;
    }
}

