/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.turbine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterial;
import it.zerono.mods.zerocore.lib.tag.CollectionProviders;
import it.zerono.mods.zerocore.lib.tag.TagList;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="bigreactors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CoilMaterialRegistry {
    private static final TagList<Block> s_tags = new TagList(CollectionProviders.BLOCKS_PROVIDER);
    private static final Map<ResourceLocation, CoilMaterial> s_materials = Maps.newHashMap();
    private static final ITextComponent TOOLTIP_COIL = new TranslationTextComponent("api.bigreactors.reactor.tooltip.coil").func_230530_a_(ExtremeReactorsAPI.STYLE_TOOLTIP);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/CoilMaterialRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean contains(BlockState state) {
        return CoilMaterialRegistry.contains(state.func_177230_c());
    }

    public static boolean contains(ITag.INamedTag<Block> tag) {
        return CoilMaterialRegistry.contains(tag.func_230234_a_());
    }

    public static boolean contains(ResourceLocation id) {
        return s_materials.containsKey(id);
    }

    public static boolean contains(Block block) {
        return s_tags.find(tag -> tag.func_230235_a_((Object)block)).isPresent();
    }

    public static Optional<CoilMaterial> get(BlockState state) {
        return CoilMaterialRegistry.get(state.func_177230_c());
    }

    public static Optional<CoilMaterial> get(ITag.INamedTag<Block> tag) {
        return CoilMaterialRegistry.get(tag.func_230234_a_());
    }

    public static Optional<CoilMaterial> get(ResourceLocation id) {
        return Optional.ofNullable(s_materials.get(id));
    }

    public static Optional<CoilMaterial> get(Block block) {
        return s_tags.find(tag -> tag.func_230235_a_((Object)block)).filter(t -> t instanceof ITag.INamedTag).map(t -> (ITag.INamedTag)t).flatMap(CoilMaterialRegistry::get);
    }

    public static void register(String tagId, float efficiency, float bonus, float extractionRate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagId) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("coilmaterial-register", () -> {
            ResourceLocation id = new ResourceLocation(tagId);
            if (s_materials.containsKey(id)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overriding existing coil data for Tag {}", (Object)tagId);
            }
            CoilMaterial c = new CoilMaterial(efficiency, bonus, extractionRate);
            s_materials.merge(id, c, (o, n) -> c);
        });
    }

    public static void remove(ITag.INamedTag<Block> tag) {
        Preconditions.checkNotNull(tag);
        CoilMaterialRegistry.remove(tag.func_230234_a_());
    }

    public static void remove(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id);
        InternalDispatcher.dispatch("coilmaterial-remove", () -> s_materials.remove(id));
    }

    public static void fillModeratorsTooltips(Map<Item, Set<ITextComponent>> tooltipsMap, NonNullSupplier<Set<ITextComponent>> setSupplier) {
        s_tags.tagStream().flatMap(blockTag -> blockTag.func_230236_b_().stream()).map(Block::func_199767_j).forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_COIL));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onVanillaTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
        s_tags.clear();
        s_materials.keySet().stream().filter(arg_0 -> ((TagsHelper)TagsHelper.BLOCKS).tagExist(arg_0)).map(arg_0 -> ((TagsHelper)TagsHelper.BLOCKS).createTag(arg_0)).forEach(arg_0 -> s_tags.addTag(arg_0));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        if (wrapper.TurbineCoils.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing Reactor reactants reactions");
            s_materials.clear();
        } else {
            Arrays.stream(wrapper.TurbineCoils.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(name -> CoilMaterialRegistry.remove(new ResourceLocation(name)));
        }
        Arrays.stream(wrapper.TurbineCoils.Add).filter(Objects::nonNull).forEach(w -> CoilMaterialRegistry.register(w.BlockTagId, w.Efficiency, w.Bonus, w.ExtractionRate));
    }
}

