/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.internal.AbstractNamedValue;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.Collections;
import java.util.Objects;

public class Reactant
extends AbstractNamedValue {
    private final ReactantType _type;
    private final Colour _colour;
    private final FuelProperties _fuelData;

    Reactant(String name, ReactantType type, int rgbColour, String translationKey, FuelProperties fuelData) {
        super(name, translationKey);
        this._type = type;
        this._colour = Colour.fromRGB((int)rgbColour);
        this._fuelData = type.isFuel() ? Objects.requireNonNull(fuelData) : FuelProperties.INVALID;
    }

    public ReactantType getType() {
        return this._type;
    }

    public Colour getColour() {
        return this._colour;
    }

    public FuelProperties getFuelData() {
        return this._fuelData;
    }

    public int getMinimumSolidSourceAmount() {
        return ReactantMappingsRegistry.getToSolid(this).orElseGet(Collections::emptyList).stream().mapToInt(IMapping::getSourceAmount).reduce(Integer::min).orElseThrow(() -> new IllegalArgumentException("No solid products mapped for reactant " + this.getName()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Reactant && super.equals(obj)) {
            Reactant other = (Reactant)obj;
            return this.getType() == other.getType() && this.getColour() == other.getColour();
        }
        return false;
    }
}

