/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.util.concurrent.ConcurrentHashMap;
import mod.chiselsandbits.render.cache.FormatInfo;
import mod.chiselsandbits.render.chiseledblock.IFaceBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class ChiselsAndBitsBakedQuad
extends BakedQuad {
    public static final ConcurrentHashMap<VertexFormat, FormatInfo> formatData = new ConcurrentHashMap();
    private final int[] processedVertexData = this.buildProcessedVertexData();

    private static int[] packData(VertexFormat format, float[][][] unpackedData) {
        FormatInfo fi = formatData.get(format);
        if (fi == null) {
            fi = new FormatInfo(format);
            formatData.put(format, fi);
        }
        return fi.pack(unpackedData);
    }

    public void pipe(IVertexConsumer consumer) {
        int[] eMap = LightUtil.mapFormats((VertexFormat)consumer.getVertexFormat(), (VertexFormat)DefaultVertexFormats.field_176600_a);
        consumer.setTexture(this.field_187509_d);
        consumer.setQuadTint(this.func_178211_c());
        consumer.setQuadOrientation(this.func_178210_d());
        consumer.setApplyDiffuseLighting(true);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().func_227894_c_().size(); ++e) {
                if (eMap[e] != consumer.getVertexFormat().func_227894_c_().size()) {
                    consumer.put(e, this.getRawPart(v, eMap[e]));
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    private float[] getRawPart(int v, int i) {
        return formatData.get(DefaultVertexFormats.field_176600_a).unpack(this.field_178215_a, v, i);
    }

    public int[] func_178209_a() {
        return this.processedVertexData;
    }

    private int[] buildProcessedVertexData() {
        int[] packed = new int[DefaultVertexFormats.field_176600_a.func_181719_f() * 4];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < DefaultVertexFormats.field_176600_a.func_227894_c_().size(); ++e) {
                LightUtil.pack((float[])this.getRawPart(v, e), (int[])packed, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)v, (int)e);
            }
        }
        return packed;
    }

    public ChiselsAndBitsBakedQuad(float[][][] unpackedData, int tint, Direction orientation, TextureAtlasSprite sprite) {
        super(ChiselsAndBitsBakedQuad.packData(DefaultVertexFormats.field_176600_a, unpackedData), tint, orientation, sprite, true);
    }

    public static class Builder
    implements IVertexConsumer,
    IFaceBuilder {
        private float[][][] unpackedData;
        private int tint = -1;
        private Direction orientation;
        private int vertices = 0;
        private int elements = 0;
        private final VertexFormat format;

        public Builder(VertexFormat format) {
            this.format = format;
        }

        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        public void setQuadOrientation(Direction orientation) {
            this.orientation = orientation;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.getVertexFormat().func_227894_c_().size()) {
                ++this.vertices;
                this.elements = 0;
            }
        }

        @Override
        public void begin() {
            if (this.format != this.getVertexFormat()) {
                throw new RuntimeException("Bad format, can only be CNB.");
            }
            this.unpackedData = new float[4][this.getVertexFormat().func_227894_c_().size()][4];
            this.tint = -1;
            this.orientation = null;
            this.vertices = 0;
            this.elements = 0;
        }

        @Override
        public BakedQuad create(TextureAtlasSprite sprite) {
            boolean isColored = false;
            return new ChiselsAndBitsBakedQuad(this.unpackedData, this.tint, this.orientation, sprite);
        }

        @Override
        public void setFace(Direction myFace, int tintIndex) {
            this.setQuadOrientation(myFace);
            this.setQuadTint(tintIndex);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        public void setTexture(TextureAtlasSprite texture) {
        }

        @Override
        public VertexFormat getFormat() {
            return this.format;
        }
    }

    public static class Colored
    extends ChiselsAndBitsBakedQuad {
        public Colored(float[][][] unpackedData, int tint, Direction orientation, TextureAtlasSprite sprite) {
            super(unpackedData, tint, orientation, sprite);
        }
    }
}

