/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PacketSetColor
extends ModPacket {
    private DyeColor newColor = DyeColor.WHITE;
    private ChiselToolType type = ChiselToolType.TAPEMEASURE;
    private boolean chatNotification = false;

    public PacketSetColor(PacketBuffer buffer) {
        this.readPayload(buffer);
    }

    public PacketSetColor(DyeColor newColor, ChiselToolType type, boolean chatNotification) {
        this.newColor = newColor;
        this.type = type;
        this.chatNotification = chatNotification;
    }

    @Override
    public void server(ServerPlayerEntity player) {
        ItemStack ei = player.func_184614_ca();
        if (ei != null && ei.func_77973_b() instanceof IChiselModeItem) {
            DyeColor originalMode = this.getColor(ei);
            this.setColor(ei, this.newColor);
            if (originalMode != this.newColor && this.chatNotification) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("chiselsandbits.color." + this.newColor.func_176762_d()), Util.field_240973_b_);
            }
        }
    }

    private void setColor(ItemStack ei, DyeColor newColor2) {
        if (ei != null) {
            ei.func_77983_a("color", (INBT)StringNBT.func_229705_a_((String)newColor2.name()));
        }
    }

    private DyeColor getColor(ItemStack ei) {
        try {
            if (ei != null && ei.func_77942_o()) {
                return DyeColor.valueOf((String)ModUtil.getTagCompound(ei).func_74779_i("color"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return DyeColor.WHITE;
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        buffer.writeBoolean(this.chatNotification);
        buffer.func_179249_a((Enum)this.type);
        buffer.func_179249_a((Enum)this.newColor);
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.chatNotification = buffer.readBoolean();
        this.type = (ChiselToolType)buffer.func_179257_a(ChiselToolType.class);
        this.newColor = (DyeColor)buffer.func_179257_a(DyeColor.class);
    }
}

