/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network;

import java.util.function.Function;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.network.ModPacketTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.0";
    private static final String ACCEPTED_PROTO_VERS = "1.0";
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chiselsandbits", channelName), () -> "1.0", "1.0"::equals, "1.0"::equals);
    }

    public void registerCommonMessages() {
        ModPacketTypes.init(this);
    }

    public <MSG extends ModPacket> void registerMessage(int id, Class<MSG> msgClazz, Function<PacketBuffer, MSG> msgCreator) {
        this.rawChannel.registerMessage(id, msgClazz, ModPacket::getPayload, msgCreator, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            ctx.enqueueWork(() -> msg.processPacket(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        });
    }

    public void sendToServer(ModPacket msg) {
        this.rawChannel.sendToServer((Object)msg);
    }

    public void sendToPlayer(ModPacket msg, ServerPlayerEntity player) {
        this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public void sendToOrigin(ModPacket msg, NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToDimension(ModPacket msg, ResourceLocation dim) {
        this.rawChannel.send(PacketDistributor.DIMENSION.with(() -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim)), (Object)msg);
    }

    public void sendToPosition(ModPacket msg, PacketDistributor.TargetPoint pos) {
        this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), (Object)msg);
    }

    public void sendToEveryone(ModPacket msg) {
        this.rawChannel.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    public void sendToTrackingEntity(ModPacket msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingEntityAndSelf(ModPacket msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingChunk(ModPacket msg, Chunk chunk) {
        this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)msg);
    }
}

