/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.List;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.network.packets.PacketSetColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTapeMeasure
extends Item
implements IChiselModeItem,
IItemScrollWheel {
    public ItemTapeMeasure(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpTapeMeasure, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_228046_af_), ClientSide.instance.getModeKey());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        if (playerIn.func_225608_bj_() && playerIn.func_130014_f_().field_72995_K) {
            ClientSide.instance.tapeMeasures.clear();
        }
        ItemStack itemstack = playerIn.func_184586_b(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            if (context.func_195999_j().func_225608_bj_()) {
                ClientSide.instance.tapeMeasures.clear();
                return ActionResultType.SUCCESS;
            }
            Pair<Vector3d, Vector3d> PlayerRay = ModUtil.getPlayerRay(context.func_195999_j());
            Vector3d ray_from = (Vector3d)PlayerRay.getLeft();
            Vector3d ray_to = (Vector3d)PlayerRay.getRight();
            RayTraceContext rayTraceContext = new RayTraceContext(ray_from, ray_to, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)context.func_195999_j());
            BlockRayTraceResult mop = context.func_195999_j().func_130014_f_().func_217299_a(rayTraceContext);
            if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BitLocation loc = new BitLocation(mop, BitOperation.CHISEL);
                ClientSide.instance.pointAt(ChiselToolType.TAPEMEASURE, loc, context.func_221531_n());
            } else {
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ITextComponent getHighlightTip(ItemStack item, ITextComponent displayName) {
        if (EffectiveSide.get().isClient() && displayName instanceof IFormattableTextComponent && ((Boolean)ChiselsAndBits.getConfig().getClient().itemNameModeDisplay.get()).booleanValue()) {
            IFormattableTextComponent formattableTextComponent = (IFormattableTextComponent)displayName;
            return formattableTextComponent.func_240702_b_(" - ").func_240702_b_(TapeMeasureModes.getMode((ItemStack)item).string.getLocal()).func_240702_b_(" - ").func_240702_b_(DeprecationHelper.translateToLocal("chiselsandbits.color." + this.getTapeColor(item).func_176762_d()));
        }
        return displayName;
    }

    public DyeColor getTapeColor(ItemStack item) {
        CompoundNBT compound = item.func_77978_p();
        if (compound != null && compound.func_74764_b("color")) {
            try {
                return DyeColor.valueOf((String)compound.func_74779_i("color"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DyeColor.WHITE;
    }

    @Override
    public void scroll(PlayerEntity player, ItemStack stack, int dwheel) {
        DyeColor color = this.getTapeColor(stack);
        int next = color.ordinal() + (dwheel < 0 ? -1 : 1);
        if (next < 0) {
            next = DyeColor.values().length - 1;
        }
        if (next >= DyeColor.values().length) {
            next = 0;
        }
        DyeColor col = DyeColor.values()[next];
        this.setTapeColor(stack, col);
        PacketSetColor setColor = new PacketSetColor(col, ChiselToolType.TAPEMEASURE, (Boolean)ChiselsAndBits.getConfig().getClient().chatModeNotification.get());
        ChiselsAndBits.getNetworkChannel().sendToServer(setColor);
        ReflectionWrapper.instance.clearHighlightedStack();
    }

    public void setTapeColor(ItemStack stack, DyeColor color) {
        stack.func_77983_a("color", (INBT)StringNBT.func_229705_a_((String)color.func_176610_l()));
    }
}

