/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.network.packets.PacketAccurateSneakPlace;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class ItemPositivePrint
extends ItemNegativePrint
implements IChiselModeItem,
PacketAccurateSneakPlace.IItemBlockAccurate {
    public ItemPositivePrint(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected Item getWrittenItem() {
        return (Item)ModItems.ITEM_POSITIVE_PRINT_WRITTEN.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        this.defaultAddInfo(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpPositivePrint, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getModeKey());
        if (stack.func_77942_o()) {
            if (ClientSide.instance.holdingShift()) {
                if (this.toolTipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.toolTipCache.updateCachedValue(blob.listContents(new ArrayList<ITextComponent>()));
                }
                tooltip.addAll((Collection)this.toolTipCache.getCached());
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(LocalStrings.ShiftDetails.getLocal()));
            }
        }
    }

    @Override
    protected CompoundNBT getCompoundFromBlock(World world, BlockPos pos, PlayerEntity player) {
        BlockState state = world.func_180495_p(pos);
        Block blkObj = state.func_177230_c();
        if (!(blkObj instanceof BlockChiseled) && BlockBitInfo.canChisel(state)) {
            NBTBlobConverter tmp = new NBTBlobConverter();
            tmp.fillWith(state);
            CompoundNBT comp = new CompoundNBT();
            tmp.writeChisleData(comp, false);
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((LivingEntity)player).ordinal());
            return comp;
        }
        return super.getCompoundFromBlock(world, pos, player);
    }

    @Override
    protected boolean convertToStone() {
        return false;
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = player.func_184586_b(hand);
        BlockState blkstate = world.func_180495_p(pos);
        if (ItemChiseledBit.checkRequiredSpace(player, blkstate)) {
            return ActionResultType.FAIL;
        }
        boolean offgrid = false;
        if (PositivePatternMode.getMode(stack) == PositivePatternMode.PLACEMENT) {
            if (!world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            PacketAccurateSneakPlace pasp = new PacketAccurateSneakPlace(context.func_195996_i(), pos, hand, context.func_196000_l(), context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c, false);
            ChiselsAndBits.getNetworkChannel().sendToServer(pasp);
        }
        return this.placeItem(context, offgrid);
    }

    public final ActionResultType placeItem(ItemUseContext context, boolean offgrid) {
        ItemStack output;
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        if (PositivePatternMode.getMode(stack) == PositivePatternMode.PLACEMENT && (output = this.getPatternedItem(stack, false)) != null) {
            Map<Integer, Integer> stats;
            VoxelBlob pattern = ModUtil.getBlobFromStack(stack, (LivingEntity)player);
            if (this.consumeEntirePattern(pattern, stats = pattern.getBlockSums(), pos, ActingPlayer.testingAs(player, hand)) && output.func_77973_b() instanceof ItemBlockChiseled) {
                ItemBlockChiseled ibc = (ItemBlockChiseled)output.func_77973_b();
                ActionResultType res = ibc.tryPlace(context, offgrid);
                if (res == ActionResultType.SUCCESS) {
                    this.consumeEntirePattern(pattern, stats, pos, ActingPlayer.actingAs(player, hand));
                }
                return res;
            }
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(context);
    }

    private boolean consumeEntirePattern(VoxelBlob pattern, Map<Integer, Integer> stats, BlockPos pos, ActingPlayer player) {
        List<BagInventory> bags = ModUtil.getBags(player);
        for (Map.Entry<Integer, Integer> type : stats.entrySet()) {
            int inPattern = type.getKey();
            if (type.getKey() == 0) continue;
            IItemInInventory bit = ModUtil.findBit(player, pos, inPattern);
            int stillNeeded = type.getValue() - ModUtil.consumeBagBit(bags, inPattern, type.getValue());
            if (stillNeeded == 0) continue;
            for (int x = stillNeeded; x > 0 && bit.isValid(); --x) {
                if (!bit.consume()) continue;
                --stillNeeded;
                bit = ModUtil.findBit(player, pos, inPattern);
            }
            if (stillNeeded == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void applyPrint(ItemStack stack, World world, BlockPos pos, Direction side, VoxelBlob vb, VoxelBlob pattern, PlayerEntity who, Hand hand) {
        ActingPlayer player = ActingPlayer.actingAs(who, hand);
        ContinousChisels selected = new ContinousChisels(player, pos, side);
        ItemStack spawnedItem = null;
        VoxelBlob filled = new VoxelBlob();
        List<BagInventory> bags = ModUtil.getBags(player);
        ArrayList<ItemEntity> spawnlist = new ArrayList<ItemEntity>();
        PositivePatternMode chiselMode = PositivePatternMode.getMode(stack);
        boolean chisel_bits = chiselMode == PositivePatternMode.IMPOSE || chiselMode == PositivePatternMode.REPLACE;
        boolean chisel_to_air = chiselMode == PositivePatternMode.REPLACE;
        for (int y = 0; y < vb.detail; ++y) {
            for (int z = 0; z < vb.detail; ++z) {
                for (int x = 0; x < vb.detail; ++x) {
                    int inPattern;
                    int inPlace = vb.get(x, y, z);
                    if (inPlace == (inPattern = pattern.get(x, y, z))) continue;
                    if (inPlace != 0 && chisel_bits && selected.isValid() && (chisel_to_air || inPattern != 0) && (spawnedItem = ItemChisel.chiselBlock(selected, player, vb, world, pos, side, x, y, z, spawnedItem, spawnlist)) != null) {
                        inPlace = 0;
                    }
                    if (inPlace != 0 || inPattern == 0 || filled.get(x, y, z) != 0) continue;
                    IItemInInventory bit = ModUtil.findBit(player, pos, inPattern);
                    if (ModUtil.consumeBagBit(bags, inPattern, 1) == 1) {
                        vb.set(x, y, z, inPattern);
                        continue;
                    }
                    if (!bit.isValid()) continue;
                    if (!player.isCreative()) {
                        if (!bit.consume()) continue;
                        vb.set(x, y, z, inPattern);
                        continue;
                    }
                    vb.set(x, y, z, inPattern);
                }
            }
        }
        BitInventoryFeeder feeder = new BitInventoryFeeder(who, world);
        for (ItemEntity ei : spawnlist) {
            feeder.addItem(ei);
            ItemBitBag.cleanupInventory(who, ei.func_92059_d());
        }
    }

    public ITextComponent getHighlightTip(ItemStack item, ITextComponent displayName) {
        if (EffectiveSide.get().isClient() && displayName instanceof IFormattableTextComponent && ((Boolean)ChiselsAndBits.getConfig().getClient().itemNameModeDisplay.get()).booleanValue()) {
            IFormattableTextComponent formattableTextComponent = (IFormattableTextComponent)displayName;
            return formattableTextComponent.func_240702_b_(" - ").func_240702_b_(PositivePatternMode.getMode((ItemStack)item).string.getLocal());
        }
        return displayName;
    }

    @Override
    public ActionResultType tryPlace(ItemUseContext context, boolean offGrid) {
        ItemStack output;
        if (PositivePatternMode.getMode(context.func_195996_i()) == PositivePatternMode.PLACEMENT && (output = this.getPatternedItem(context.func_195996_i(), false)) != null) {
            Map<Integer, Integer> stats;
            VoxelBlob pattern = ModUtil.getBlobFromStack(context.func_195996_i(), (LivingEntity)context.func_195999_j());
            if (this.consumeEntirePattern(pattern, stats = pattern.getBlockSums(), context.func_195995_a(), ActingPlayer.testingAs(context.func_195999_j(), context.func_221531_n())) && output.func_77973_b() instanceof ItemBlockChiseled) {
                ItemBlockChiseled ibc = (ItemBlockChiseled)output.func_77973_b();
                ActionResultType res = ibc.tryPlace((ItemUseContext)new BlockItemUseContext(context), offGrid);
                if (res == ActionResultType.SUCCESS) {
                    this.consumeEntirePattern(pattern, stats, context.func_195995_a(), ActingPlayer.actingAs(context.func_195999_j(), context.func_221531_n()));
                }
                return res;
            }
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(context);
    }
}

