/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import com.google.common.base.Stopwatch;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.network.packets.PacketChisel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemChisel
extends ToolItem
implements IItemScrollWheel,
IChiselModeItem {
    private static final float one_16th = 0.0625f;
    private static Stopwatch timer;
    private static boolean testingChisel;

    public ItemChisel(IItemTier material, Item.Properties properties) {
        super(0.1f, -2.8f, material, new HashSet(), ItemChisel.setupDamageStack(material, properties));
    }

    private static Item.Properties setupDamageStack(IItemTier material, Item.Properties properties) {
        long uses = 1L;
        if (ItemTier.DIAMOND.equals((Object)material)) {
            uses = ((Integer)ChiselsAndBits.getConfig().getServer().diamondChiselUses.get()).intValue();
        } else if (ItemTier.GOLD.equals((Object)material)) {
            uses = ((Integer)ChiselsAndBits.getConfig().getServer().goldChiselUses.get()).intValue();
        } else if (ItemTier.IRON.equals((Object)material)) {
            uses = ((Integer)ChiselsAndBits.getConfig().getServer().ironChiselUses.get()).intValue();
        } else if (ItemTier.STONE.equals((Object)material)) {
            uses = ((Integer)ChiselsAndBits.getConfig().getServer().stoneChiselUses.get()).intValue();
        } else if (ItemTier.NETHERITE.equals((Object)material)) {
            uses = ((Integer)ChiselsAndBits.getConfig().getServer().netheriteChiselUses.get()).intValue();
        }
        return properties.func_200918_c((Boolean)ChiselsAndBits.getConfig().getServer().damageTools.get() != false ? (int)Math.max(0L, uses) : 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpChisel, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74312_F), ClientSide.instance.getModeKey());
    }

    public static void resetDelay() {
        timer = null;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return ItemChisel.fromBreakToChisel(ChiselMode.castMode(ChiselModeManager.getChiselMode(player, ChiselToolType.CHISEL, Hand.MAIN_HAND)), itemstack, pos, player, Hand.MAIN_HAND);
    }

    public static boolean fromBreakToChisel(ChiselMode mode, ItemStack itemstack, @Nonnull BlockPos pos, PlayerEntity player, Hand hand) {
        BlockState state = player.func_130014_f_().func_180495_p(pos);
        if (ItemChiseledBit.checkRequiredSpace(player, state)) {
            return false;
        }
        if (BlockBitInfo.canChisel(state)) {
            if (itemstack != null && (timer == null || timer.elapsed(TimeUnit.MILLISECONDS) > 150L)) {
                Vector3d ray_to;
                timer = Stopwatch.createStarted();
                if (mode == ChiselMode.DRAWN_REGION) {
                    Vector3d ray_to2;
                    Pair<Vector3d, Vector3d> PlayerRay = ModUtil.getPlayerRay(player);
                    Vector3d ray_from = (Vector3d)PlayerRay.getLeft();
                    RayTraceContext context = new RayTraceContext(ray_from, ray_to2 = (Vector3d)PlayerRay.getRight(), RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, (Entity)player);
                    BlockRayTraceResult mop = player.field_70170_p.func_217299_a(context);
                    if (mop != null && mop instanceof BlockRayTraceResult) {
                        BlockRayTraceResult rayTraceResult = mop;
                        BitLocation loc = new BitLocation(rayTraceResult, BitOperation.CHISEL);
                        ClientSide.instance.pointAt(ChiselToolType.CHISEL, loc, hand);
                        return true;
                    }
                    return true;
                }
                if (!player.field_70170_p.field_72995_K) {
                    return true;
                }
                Pair<Vector3d, Vector3d> PlayerRay = ModUtil.getPlayerRay(player);
                Vector3d ray_from = (Vector3d)PlayerRay.getLeft();
                RayTraceContext context = new RayTraceContext(ray_from, ray_to = (Vector3d)PlayerRay.getRight(), RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, (Entity)player);
                BlockRayTraceResult mop = player.field_70170_p.func_217299_a(context);
                if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
                    BlockRayTraceResult minecraftResult;
                    if ((Minecraft.func_71410_x().field_71476_x != null ? Minecraft.func_71410_x().field_71476_x.func_216346_c() : RayTraceResult.Type.MISS) == RayTraceResult.Type.BLOCK && !(minecraftResult = (BlockRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216350_a().func_185334_h().equals((Object)mop.func_216350_a().func_185334_h())) {
                        mop = minecraftResult;
                    }
                    ItemChisel.useChisel(mode, player, player.field_70170_p, mop, hand);
                }
            }
            return true;
        }
        if (player.func_130014_f_().field_72995_K) {
            return ClientSide.instance.getStartPos() != null;
        }
        return false;
    }

    public ITextComponent getHighlightTip(ItemStack item, ITextComponent displayName) {
        if (EffectiveSide.get().isClient() && ((Boolean)ChiselsAndBits.getConfig().getClient().itemNameModeDisplay.get()).booleanValue() && displayName instanceof IFormattableTextComponent) {
            IFormattableTextComponent formattableTextComponent = (IFormattableTextComponent)displayName;
            if (((Boolean)ChiselsAndBits.getConfig().getClient().perChiselMode.get()).booleanValue() || EffectiveSide.get().isServer()) {
                return formattableTextComponent.func_240702_b_(" - ").func_240702_b_(ChiselMode.getMode((ItemStack)item).string.getLocal());
            }
            return formattableTextComponent.func_240702_b_(" - ").func_240702_b_(ChiselModeManager.getChiselMode(ClientSide.instance.getPlayer(), ChiselToolType.CHISEL, Hand.MAIN_HAND).getName().getLocal());
        }
        return displayName;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K && ((Boolean)ChiselsAndBits.getConfig().getClient().enableRightClickModeChange.get()).booleanValue()) {
            IToolMode mode = ChiselModeManager.getChiselMode(playerIn, ChiselToolType.CHISEL, hand);
            ChiselModeManager.scrollOption(ChiselToolType.CHISEL, mode, mode, playerIn.func_225608_bj_() ? -1 : 1);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().field_72995_K && ((Boolean)ChiselsAndBits.getConfig().getClient().enableRightClickModeChange.get()).booleanValue()) {
            this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    static void useChisel(ChiselMode mode, PlayerEntity player, World world, BlockRayTraceResult rayTraceResult, Hand hand) {
        BitLocation location = new BitLocation(rayTraceResult, BitOperation.CHISEL);
        PacketChisel pc = new PacketChisel(BitOperation.CHISEL, location, rayTraceResult.func_216354_b(), mode, hand);
        int extractedState = pc.doAction(player);
        if (extractedState != 0) {
            ClientSide.breakSound(world, rayTraceResult.func_216350_a(), extractedState);
            ChiselsAndBits.getNetworkChannel().sendToServer(pc);
        }
    }

    public static ItemStack chiselBlock(IContinuousInventory selected, ActingPlayer player, VoxelBlob vb, World world, BlockPos pos, Direction side, int x, int y, int z, ItemStack output, List<ItemEntity> spawnlist) {
        boolean isCreative = player.isCreative();
        int blk = vb.get(x, y, z);
        if (blk == 0) {
            return output;
        }
        if (!ItemChisel.canMine(selected, ModUtil.getStateById(blk), player.getPlayer(), world, pos)) {
            return output;
        }
        if (!selected.useItem(blk)) {
            return output;
        }
        if (!world.field_72995_K && !isCreative) {
            double hitX = (float)x * 0.0625f;
            double hitY = (float)y * 0.0625f;
            double hitZ = (float)z * 0.0625f;
            double offset = 0.5;
            hitX += (double)side.func_82601_c() * 0.5;
            hitY += (double)side.func_96559_d() * 0.5;
            hitZ += (double)side.func_82599_e() * 0.5;
            if (output == null || !ItemChiseledBit.sameBit(output, blk) || ModUtil.getStackSize(output) == 64) {
                output = ItemChiseledBit.createStack(blk, 1, true);
                spawnlist.add(new ItemEntity(world, (double)pos.func_177958_n() + hitX, (double)pos.func_177956_o() + hitY, (double)pos.func_177952_p() + hitZ, output));
            } else {
                ModUtil.adjustStackSize(output, 1);
            }
        } else {
            output = ItemChiseledBit.createStack(blk, 1, true);
        }
        vb.clear(x, y, z);
        return output;
    }

    public static boolean canMine(IContinuousInventory chiselInv, BlockState state, PlayerEntity player, World world, @Nonnull BlockPos pos) {
        int targetState = ModUtil.getStateId(state);
        IItemInInventory chiselSlot = chiselInv.getItem(targetState);
        ItemStack chisel = chiselSlot.getStack();
        if (player.func_184812_l_()) {
            return world.func_175660_a(player, pos);
        }
        if (ModUtil.isEmpty(chisel)) {
            return false;
        }
        if (((Boolean)ChiselsAndBits.getConfig().getServer().enableChiselToolHarvestCheck.get()).booleanValue()) {
            if (state.func_177230_c() instanceof BlockChiseled) {
                return ((BlockChiseled)state.func_177230_c()).basicHarvestBlockTest(world, pos, player);
            }
            do {
                Block blk = world.func_180495_p(pos).func_177230_c();
                BlockChiseled.setActingAs(state);
                testingChisel = true;
                chiselSlot.swapWithWeapon();
                boolean canHarvest = world.func_180495_p(pos).canHarvestBlock((IBlockReader)world, pos, player);
                chiselSlot.swapWithWeapon();
                testingChisel = false;
                BlockChiseled.setActingAs(null);
                if (canHarvest) {
                    return true;
                }
                chiselInv.fail(targetState);
            } while (!ModUtil.isEmpty(chisel = (chiselSlot = chiselInv.getItem(targetState)).getStack()));
            return false;
        }
        return true;
    }

    public boolean func_150897_b(BlockState blk) {
        IItemTier tier = this.func_200891_e();
        Item it = ItemTier.DIAMOND.equals((Object)tier) ? Items.field_151046_w : (ItemTier.GOLD.equals((Object)tier) ? Items.field_151005_D : (ItemTier.IRON.equals((Object)tier) ? Items.field_151035_b : (ItemTier.WOOD.equals((Object)tier) ? Items.field_151039_o : Items.field_151050_s)));
        return blk.func_177230_c() instanceof BlockChiseled || it.func_150897_b(blk);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        String pattern;
        Pattern p;
        Matcher m;
        if (testingChisel && stack.func_77973_b() instanceof ItemChisel && (m = (p = Pattern.compile(pattern = "(^|,)" + Pattern.quote(tool.getName()) + "(,|$)")).matcher((CharSequence)ChiselsAndBits.getConfig().getServer().enableChiselToolHarvestCheckTools.get())).find()) {
            ItemChisel ic = (ItemChisel)stack.func_77973_b();
            return ic.func_200891_e().func_200925_d();
        }
        return super.getHarvestLevel(stack, tool, player, blockState);
    }

    @Override
    public void scroll(PlayerEntity player, ItemStack stack, int dwheel) {
        IToolMode mode = ChiselModeManager.getChiselMode(player, ChiselToolType.CHISEL, Hand.MAIN_HAND);
        ChiselModeManager.scrollOption(ChiselToolType.CHISEL, mode, mode, dwheel);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    static {
        testingChisel = false;
    }
}

