/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.debug;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.BitQueryResults;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public abstract class DebugAction {
    public static IChiselAndBitsAPI api;

    protected static void Msg(PlayerEntity player, String msg) {
        String side = EffectiveSide.get().name() + ": ";
        player.func_145747_a((ITextComponent)new StringTextComponent(side + msg), Util.field_240973_b_);
    }

    private static void apiAssert(String name, PlayerEntity player, boolean must_be_true) {
        if (!must_be_true) {
            DebugAction.Msg(player, name + " = false");
        }
    }

    public abstract void run(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull Direction var3, double var4, double var6, double var8, @Nonnull PlayerEntity var10);

    static class createBitItem
    extends DebugAction {
        createBitItem() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                player.field_71071_by.func_70441_a(access.getBitsAsItem(side, ItemType.CHISLED_BLOCK, false));
                player.field_71071_by.func_70441_a(access.getBitsAsItem(side, ItemType.MIRROR_DESIGN, false));
                player.field_71071_by.func_70441_a(access.getBitsAsItem(side, ItemType.NEGATIVE_DESIGN, false));
                player.field_71071_by.func_70441_a(access.getBitsAsItem(side, ItemType.POSITIVE_DESIGN, false));
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class occlusionTest
    extends DebugAction {
        occlusionTest() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            VoxelBlob out = new VoxelBlob();
            player.func_145747_a((ITextComponent)new StringTextComponent(out.filled() + " blocked"), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)new StringTextComponent(out.air() + " not-blocked"), Util.field_240973_b_);
        }
    }

    static class getBit
    extends DebugAction {
        getBit() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                IBitBrush brush = access.getBitAt(loc.getBitX(), loc.getBitY(), loc.getBitZ());
                if (brush == null) {
                    getBit.Msg(player, "AIR!");
                } else {
                    BlockState state = brush.getState();
                    if (state != null) {
                        Block blk = state.func_177230_c();
                        ItemStack it = brush.getItemStack(1);
                        if (it != null && it.func_77973_b() != null) {
                            player.field_71071_by.func_70441_a(it);
                        }
                        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)blk, 1));
                    }
                }
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class listContents
    extends DebugAction {
        listContents() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                final HashMap bucket = new HashMap();
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                access.visitBits(new IBitVisitor(){

                    @Override
                    public IBitBrush visitBit(int x, int y, int z, IBitBrush currentValue) {
                        if (bucket.containsKey(currentValue.getStateID())) {
                            ModUtil.adjustStackSize((ItemStack)bucket.get(currentValue.getStateID()), 1);
                        } else {
                            bucket.put(currentValue.getStateID(), currentValue.getItemStack(1));
                        }
                        return currentValue;
                    }
                });
                for (Map.Entry is : bucket.entrySet()) {
                    player.field_71071_by.func_70441_a((ItemStack)is.getValue());
                }
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class Spin
    extends DebugAction {
        Spin() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                access.rotate(side.func_176740_k(), Rotation.CLOCKWISE_90);
                access.commitChanges(true);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class Mirror
    extends DebugAction {
        Mirror() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                access.mirror(side.func_176740_k());
                access.commitChanges(true);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class Randomize
    extends DebugAction {
        Randomize() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                access.visitBits(new IBitVisitor(){

                    @Override
                    public IBitBrush visitBit(int x, int y, int z, IBitBrush currentValue) {
                        IBitBrush bit = currentValue;
                        BlockState state = Blocks.field_196602_ba.func_176223_P();
                        try {
                            bit = api.createBrush(api.getBitItem(state));
                        }
                        catch (APIExceptions.InvalidBitItem invalidBitItem) {
                            // empty catch block
                        }
                        return y % 2 == 0 ? currentValue : bit;
                    }
                });
                access.commitChanges(true);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class setBitAccess
    extends DebugAction {
        setBitAccess() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                IBitBrush brush = api.createBrush(ModUtil.getEmptyStack());
                access.setBitAt(loc.getBitX(), loc.getBitY(), loc.getBitZ(), brush);
                access.commitChanges(true);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
            catch (APIExceptions.SpaceOccupied e) {
                Log.logError("FAIL", e);
            }
            catch (APIExceptions.InvalidBitItem e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class queryTest
    extends DebugAction {
        queryTest() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, false);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                this.output(player, access.queryBitRange(new BlockPos(-1, -1, -1), new BlockPos(16, 16, 16)));
                this.output(player, access.queryBitRange(new BlockPos(1, 1, 1), new BlockPos(14, 14, 14)));
                this.output(player, access.queryBitRange(new BlockPos(0, 15, 0), new BlockPos(15, 15, 15)));
                this.output(player, access.queryBitRange(new BlockPos(0, 15, 15), new BlockPos(15, 15, 15)));
                this.output(player, access.queryBitRange(new BlockPos(0, 0, 0), new BlockPos(15, 15, 0)));
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
        }

        private void output(PlayerEntity player, BitQueryResults queryBitRange) {
            queryTest.Msg(player, queryBitRange.total + " = e" + queryBitRange.empty + " + s" + queryBitRange.solid + " + f" + queryBitRange.fluid);
        }
    }

    static class getBitAccess
    extends DebugAction {
        getBitAccess() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitLocation loc = api.getBitPos(hitX, hitY, hitZ, side, pos, true);
            try {
                IBitAccess access = api.getBitAccess(w, loc.getBlockPos());
                IBitBrush brush = api.createBrush(api.getBitItem(Blocks.field_150347_e.func_176223_P()));
                access.setBitAt(loc.getBitX(), loc.getBitY(), loc.getBitZ(), brush);
                access.commitChanges(true);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                Log.logError("FAIL", e);
            }
            catch (APIExceptions.SpaceOccupied e) {
                Log.logError("FAIL", e);
            }
            catch (APIExceptions.InvalidBitItem e) {
                Log.logError("FAIL", e);
            }
        }
    }

    static class isBlockChiseled
    extends DebugAction {
        isBlockChiseled() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            isBlockChiseled.Msg(player, "isBlockChiseled = " + (api.isBlockChiseled(w, pos) ? "true" : "false"));
        }
    }

    static class canBeChiseled
    extends DebugAction {
        canBeChiseled() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            canBeChiseled.Msg(player, "canBeChiseled = " + (api.canBeChiseled(w, pos) ? "true" : "false"));
        }
    }

    static class getTileClass
    extends DebugAction {
        getTileClass() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            TileEntity te = w.func_175625_s(pos);
            if (te != null) {
                getTileClass.Msg(player, te.getClass().getName());
            }
        }
    }

    static class ItemTests
    extends DebugAction {
        ItemTests() {
        }

        @Override
        public void run(World w, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, PlayerEntity player) {
            IBitAccess access = api.createBitItem(ModUtil.getEmptyStack());
            assert (access != null);
            DebugAction.apiAssert("BIT_BAG", player, ItemTests.api.getItemType(new ItemStack((IItemProvider)ModItems.ITEM_BIT_BAG_DEFAULT.get())) == ItemType.BIT_BAG);
            DebugAction.apiAssert("CHISEL", player, ItemTests.api.getItemType(new ItemStack((IItemProvider)ModItems.ITEM_CHISEL_DIAMOND.get())) == ItemType.CHISEL);
            DebugAction.apiAssert("MIRROR_DESIGN 1", player, ItemTests.api.getItemType(new ItemStack((IItemProvider)ModItems.ITEM_MIRROR_PRINT.get())) == ItemType.MIRROR_DESIGN);
            DebugAction.apiAssert("NEGATIVE_DESIGN 1", player, ItemTests.api.getItemType(new ItemStack((IItemProvider)ModItems.ITEM_NEGATIVE_PRINT.get())) == ItemType.NEGATIVE_DESIGN);
            DebugAction.apiAssert("POSITIVE_DESIGN 1", player, ItemTests.api.getItemType(new ItemStack((IItemProvider)ModItems.ITEM_POSITIVE_PRINT.get())) == ItemType.POSITIVE_DESIGN);
            DebugAction.apiAssert("WRENCH", player, ItemTests.api.getItemType(new ItemStack((IItemProvider)ModItems.ITEM_WRENCH.get())) == ItemType.WRENCH);
            DebugAction.apiAssert("CHISLED_BIT-cobblestone", player, ItemTests.api.getItemType(ItemChiseledBit.createStack(ModUtil.getStateId(Blocks.field_150347_e.func_176223_P()), 1, true)) == ItemType.CHISLED_BIT);
            DebugAction.apiAssert("CHISLED_BLOCK", player, ItemTests.api.getItemType(access.getBitsAsItem(Direction.UP, ItemType.CHISLED_BLOCK, false)) == null);
            DebugAction.apiAssert("MIRROR_DESIGN 2", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.MIRROR_DESIGN, false)) == null);
            DebugAction.apiAssert("NEGATIVE_DESIGN 2", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.NEGATIVE_DESIGN, false)) == null);
            DebugAction.apiAssert("POSITIVE_DESIGN 2", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.POSITIVE_DESIGN, false)) == null);
            try {
                ItemStack bitItem = api.getBitItem(Blocks.field_150347_e.func_176223_P());
                IBitBrush brush = api.createBrush(bitItem);
                access.setBitAt(0, 0, 0, brush);
            }
            catch (APIExceptions.InvalidBitItem e) {
                DebugAction.apiAssert("createBrush/getBitItem", player, false);
            }
            catch (APIExceptions.SpaceOccupied e) {
                DebugAction.apiAssert("setBitAt", player, false);
            }
            DebugAction.apiAssert("CHISLED_BLOCK 2", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false)) == ItemType.CHISLED_BLOCK);
            DebugAction.apiAssert("MIRROR_DESIGN 3", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.MIRROR_DESIGN, false)) == ItemType.MIRROR_DESIGN);
            DebugAction.apiAssert("NEGATIVE_DESIGN 3", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.NEGATIVE_DESIGN, false)) == ItemType.NEGATIVE_DESIGN);
            DebugAction.apiAssert("POSITIVE_DESIGN 3", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.POSITIVE_DESIGN, false)) == ItemType.POSITIVE_DESIGN);
            DebugAction.apiAssert("WRENCH", player, ItemTests.api.getItemType(access.getBitsAsItem(null, ItemType.WRENCH, false)) == null);
        }
    }

    static enum Tests {
        canBeChiseled(new canBeChiseled()),
        createBitItem(new createBitItem()),
        getBit(new getBit()),
        listContents(new listContents()),
        getBitAccess(new getBitAccess()),
        setBitAccess(new setBitAccess()),
        isBlockChiseled(new isBlockChiseled()),
        ItemTests(new ItemTests()),
        Randomize(new Randomize()),
        Spin(new Spin()),
        Mirror(new Mirror()),
        getTileClass(new getTileClass()),
        occusionTest(new occlusionTest()),
        queryTest(new queryTest());

        final DebugAction which;

        private Tests(DebugAction action) {
            this.which = action;
        }
    }
}

