/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.models.item.ItemModelJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.MaterialType;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChiselBlockItemModelGenerator
implements IDataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new ChiselBlockItemModelGenerator(event.getGenerator()));
    }

    private ChiselBlockItemModelGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        for (MaterialType materialType : ModBlocks.VALID_CHISEL_MATERIALS) {
            RegistryObject<BlockChiseled> blockChiseledRegistryObject = ModBlocks.getMaterialToBlockConversions().get(materialType.getType());
            BlockChiseled blockChiseled = (BlockChiseled)blockChiseledRegistryObject.get();
            this.actOnBlockWithLoader(cache, blockChiseled, new ResourceLocation("chiselsandbits", "chiseled_block"), materialType);
        }
        this.actOnBlockWithParent(cache, (Block)ModBlocks.CHISEL_PRINTER_BLOCK.get(), Constants.DataGenerator.CHISEL_PRINTER_MODEL);
    }

    public String func_200397_b() {
        return "Chisel block item model generator";
    }

    public void actOnBlockWithParent(DirectoryCache cache, Block block, ResourceLocation parent) throws IOException {
        ItemModelJson json = new ItemModelJson();
        json.setParent(parent.toString());
        this.saveBlockJson(cache, block, json, Objects.requireNonNull(block.getRegistryName()).func_110623_a());
    }

    public void actOnBlockWithLoader(DirectoryCache cache, Block block, ResourceLocation loader, MaterialType materialType) throws IOException {
        ItemModelJson json = new ItemModelJson();
        json.setParent("item/generated");
        json.setLoader(loader.toString());
        this.saveBlockJson(cache, block, json, "chiseled" + materialType.getName());
    }

    private void saveBlockJson(DirectoryCache cache, Block block, ItemModelJson json, String name) throws IOException {
        Path itemModelFolder = this.generator.func_200391_b().resolve("assets/chiselsandbits/models/item/");
        Path itemModelPath = itemModelFolder.resolve(name + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)json.serialize(), (Path)itemModelPath);
    }
}

