/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.blockstate;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.printer.ChiselPrinterBlock;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChiselPrinterBlockStateGenerator
implements IDataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new ChiselPrinterBlockStateGenerator(event.getGenerator()));
    }

    private ChiselPrinterBlockStateGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.actOnBlock(cache, (Block)ModBlocks.CHISEL_PRINTER_BLOCK.get());
    }

    public void actOnBlock(DirectoryCache cache, Block block) throws IOException {
        HashMap variants = Maps.newHashMap();
        ChiselPrinterBlock.FACING.func_177700_c().forEach(dir -> {
            String variantKey = String.format("%s=%s", ChiselPrinterBlock.FACING.func_177701_a(), dir);
            String modelFile = Constants.DataGenerator.CHISEL_PRINTER_MODEL.toString();
            BlockstateModelJson model = new BlockstateModelJson(modelFile, 0, (int)dir.func_176734_d().func_185119_l());
            variants.put(variantKey, new BlockstateVariantJson(model));
        });
        BlockstateJson blockstateJson = new BlockstateJson((Map)variants);
        Path blockstateFolder = this.generator.func_200391_b().resolve("assets/chiselsandbits/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(block.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)blockstateJson.serialize(), (Path)blockstatePath);
    }

    public String func_200397_b() {
        return "ChiselStation blockstate generator";
    }
}

