/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import mod.chiselsandbits.config.AbstractConfiguration;
import net.minecraft.block.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfiguration
extends AbstractConfiguration {
    public ForgeConfigSpec.BooleanValue logTileErrors;
    public ForgeConfigSpec.BooleanValue logEligibilityErrors;
    public ForgeConfigSpec.BooleanValue blackListRandomTickingBlocks;
    public ForgeConfigSpec.BooleanValue damageTools;
    public ForgeConfigSpec.BooleanValue enableChiselToolHarvestCheck;
    public ForgeConfigSpec.ConfigValue<String> enableChiselToolHarvestCheckTools;
    public ForgeConfigSpec.BooleanValue enableToolHarvestLevels;
    public ForgeConfigSpec.BooleanValue enableBitLightSource;
    public ForgeConfigSpec.DoubleValue bitLightPercentage;
    public ForgeConfigSpec.BooleanValue compatabilityMode;
    public ForgeConfigSpec.IntValue bagStackSize;
    public ForgeConfigSpec.IntValue stoneChiselUses;
    public ForgeConfigSpec.IntValue ironChiselUses;
    public ForgeConfigSpec.IntValue diamondChiselUses;
    public ForgeConfigSpec.IntValue netheriteChiselUses;
    public ForgeConfigSpec.IntValue goldChiselUses;
    public ForgeConfigSpec.IntValue wrenchUses;
    public ForgeConfigSpec.IntValue stoneSawUses;
    public ForgeConfigSpec.IntValue ironSawUses;
    public ForgeConfigSpec.IntValue goldSawUses;
    public ForgeConfigSpec.IntValue diamondSawUses;
    public ForgeConfigSpec.IntValue netheriteSawUses;
    public ForgeConfigSpec.BooleanValue fullBlockCrafting;
    public ForgeConfigSpec.BooleanValue requireBagSpace;
    public ForgeConfigSpec.BooleanValue voidExcessBits;
    public ForgeConfigSpec.IntValue creativeClipboardSize;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> revertibleBlocks;
    public ForgeConfigSpec.BooleanValue lowMemoryMode;

    protected ServerConfiguration(ForgeConfigSpec.Builder builder) {
        ServerConfiguration.createCategory(builder, "server.troubleshooting");
        this.logTileErrors = ServerConfiguration.defineBoolean(builder, "server.troubleshooting.logging.tile-errors", true);
        this.logEligibilityErrors = ServerConfiguration.defineBoolean(builder, "server.troubleshooting.logging.eligibility-errors", true);
        ServerConfiguration.finishCategory(builder);
        ServerConfiguration.createCategory(builder, "server.balancing");
        this.blackListRandomTickingBlocks = ServerConfiguration.defineBoolean(builder, "server.balancing.random-ticking-blocks.blacklisted", false);
        this.damageTools = ServerConfiguration.defineBoolean(builder, "server.balancing.tools.damage", true);
        this.enableChiselToolHarvestCheck = ServerConfiguration.defineBoolean(builder, "server.balancing.chisel-tool.harvest-check.enabled", false);
        this.enableChiselToolHarvestCheckTools = ServerConfiguration.defineString(builder, "server.balancing.chisel-tool.harvest-check.tools", "");
        this.enableToolHarvestLevels = ServerConfiguration.defineBoolean(builder, "server.balancing.tools.harvest-levels.enabled", true);
        this.enableBitLightSource = ServerConfiguration.defineBoolean(builder, "server.balancing.bits.act-as-light-source", true);
        this.bitLightPercentage = ServerConfiguration.defineDouble(builder, "server.balancing.bits.light-percentage", 6.25);
        this.compatabilityMode = ServerConfiguration.defineBoolean(builder, "server.balancing.compatibility-mode.enabled", false);
        this.bagStackSize = ServerConfiguration.defineInteger(builder, "server.balancing.bag.stack-size", 512);
        this.stoneChiselUses = ServerConfiguration.defineInteger(builder, "server.balancing.chisel-uses.stone", 12288);
        this.ironChiselUses = ServerConfiguration.defineInteger(builder, "server.balancing.chisel-uses.iron", 110592);
        this.diamondChiselUses = ServerConfiguration.defineInteger(builder, "server.balancing.chisel-uses.diamond", 995328);
        this.netheriteChiselUses = ServerConfiguration.defineInteger(builder, "server.balancing.chisel-uses.netherite", 0x88B000);
        this.goldChiselUses = ServerConfiguration.defineInteger(builder, "server.balancing.chisel-uses.gold", 1024);
        this.wrenchUses = ServerConfiguration.defineInteger(builder, "server.balancing.wrench-uses", 1888);
        this.stoneSawUses = ServerConfiguration.defineInteger(builder, "server.balancing.saw-uses.stone", 512);
        this.goldSawUses = ServerConfiguration.defineInteger(builder, "server.balancing.saw-uses.gold", 500);
        this.ironSawUses = ServerConfiguration.defineInteger(builder, "server.balancing.saw-uses.iron", 2048);
        this.diamondSawUses = ServerConfiguration.defineInteger(builder, "server.balancing.saw-uses.diamond", 8192);
        this.netheriteSawUses = ServerConfiguration.defineInteger(builder, "server.balancing.saw-uses.netherite", 32768);
        this.fullBlockCrafting = ServerConfiguration.defineBoolean(builder, "server.balancing.full-block-crafting.enabled", true);
        this.requireBagSpace = ServerConfiguration.defineBoolean(builder, "server.balancing.bag-space.required", true);
        this.voidExcessBits = ServerConfiguration.defineBoolean(builder, "server.balancing.bag-space.void-excess", true);
        this.creativeClipboardSize = ServerConfiguration.defineInteger(builder, "server.balancing.clipboard.size.creative", 10);
        this.revertibleBlocks = ServerConfiguration.defineList(builder, "server.balancing.revertible.blocks", Lists.newArrayList((Object[])new String[]{"*"}), o -> o instanceof String);
        ServerConfiguration.finishCategory(builder);
        ServerConfiguration.createCategory(builder, "server.performance");
        this.lowMemoryMode = ServerConfiguration.defineBoolean(builder, "server.performance.memory.low-mode.enabled", false);
        ServerConfiguration.finishCategory(builder);
    }

    public boolean canRevertToBlock(BlockState newState) {
        List blockNames = (List)this.revertibleBlocks.get();
        return blockNames.contains("*") || blockNames.contains(Objects.requireNonNull(newState.func_177230_c().getRegistryName()).toString());
    }
}

