/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.util.BitSet;
import java.util.Objects;
import mod.chiselsandbits.api.BoxType;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelShapeCalculator;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.util.math.shapes.VoxelShape;

public final class VoxelShapeCache {
    private static final VoxelShapeCache INSTANCE = new VoxelShapeCache();
    private final SimpleMaxSizedCache<CacheKey, VoxelShape> cache;

    public static VoxelShapeCache getInstance() {
        return INSTANCE;
    }

    private VoxelShapeCache() {
        this.cache = new SimpleMaxSizedCache((Long)ChiselsAndBits.getConfig().getCommon().collisionBoxCacheSize.get());
    }

    public VoxelShape get(VoxelBlob blob, BoxType type) {
        CacheKey key = new CacheKey(type, (BitSet)blob.getNoneAir().clone());
        VoxelShape shape = this.cache.get(key);
        if (shape == null) {
            shape = this.calculateNewVoxelShape(blob, type);
            this.cache.put(key, shape);
        }
        return shape;
    }

    private VoxelShape calculateNewVoxelShape(VoxelBlob data, BoxType type) {
        return VoxelShapeCalculator.calculate(data, type).func_197753_c();
    }

    private static final class CacheKey {
        private final BoxType type;
        private final BitSet noneAirMap;

        private CacheKey(BoxType type, BitSet noneAirMap) {
            this.type = type;
            this.noneAirMap = noneAirMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.type == cacheKey.type && this.noneAirMap.equals(cacheKey.noneAirMap);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.noneAirMap});
        }
    }
}

