/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import mod.chiselsandbits.bitbag.BagContainer;
import mod.chiselsandbits.bitbag.GuiBagFontRenderer;
import mod.chiselsandbits.bitbag.GuiIconButton;
import mod.chiselsandbits.bitbag.TargetedInventory;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.network.packets.PacketBagGui;
import mod.chiselsandbits.network.packets.PacketClearBagGui;
import mod.chiselsandbits.network.packets.PacketSortBagGui;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class BagGui
extends ContainerScreen<BagContainer> {
    private static final ResourceLocation BAG_GUI_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/bitbag.png");
    private static GuiBagFontRenderer specialFontRenderer = null;
    private GuiIconButton trashBtn;
    private Slot hoveredBitSlot = null;
    boolean requireConfirm = true;
    boolean dontThrow = false;

    public BagGui(BagContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147000_g = 239;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.trashBtn = (GuiIconButton)this.func_230480_a_((Widget)new GuiIconButton(this.field_147003_i - 18, this.field_147009_r + 0, ClientSide.trashIcon, p_onPress_1_ -> {
            if (this.requireConfirm) {
                this.dontThrow = true;
                if (this.isValidBitItem()) {
                    this.requireConfirm = false;
                }
            } else {
                this.requireConfirm = true;
                ChiselsAndBits.getNetworkChannel().sendToServer(new PacketClearBagGui(this.getInHandItem()));
                this.dontThrow = false;
            }
        }, (p_onTooltip_1_, p_onTooltip_2_, p_onTooltip_3_, p_onTooltip_4_) -> {
            if (this.isValidBitItem()) {
                String msgNotConfirm = ModUtil.notEmpty(this.getInHandItem()) ? LocalStrings.TrashItem.getLocal(this.getInHandItem().func_200301_q().getString()) : LocalStrings.Trash.getLocal();
                String msgConfirm = ModUtil.notEmpty(this.getInHandItem()) ? LocalStrings.ReallyTrashItem.getLocal(this.getInHandItem().func_200301_q().getString()) : LocalStrings.ReallyTrash.getLocal();
                List<ITextComponent> text = Arrays.asList(new StringTextComponent(this.requireConfirm ? msgNotConfirm : msgConfirm));
                GuiUtils.drawHoveringText((MatrixStack)p_onTooltip_2_, text, (int)p_onTooltip_3_, (int)p_onTooltip_4_, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            } else {
                List<ITextComponent> text = Arrays.asList(new StringTextComponent(LocalStrings.TrashInvalidItem.getLocal(this.getInHandItem().func_200301_q().getString())));
                GuiUtils.drawHoveringText((MatrixStack)p_onTooltip_2_, text, (int)p_onTooltip_3_, (int)p_onTooltip_4_, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }));
        GuiIconButton sortBtn = (GuiIconButton)this.func_230480_a_((Widget)new GuiIconButton(this.field_147003_i - 18, this.field_147009_r + 18, ClientSide.sortIcon, new Button.IPressable(){

            public void onPress(Button p_onPress_1_) {
                ChiselsAndBits.getNetworkChannel().sendToServer(new PacketSortBagGui());
            }
        }, (p_onTooltip_1_, p_onTooltip_2_, p_onTooltip_3_, p_onTooltip_4_) -> {
            List<ITextComponent> text = Arrays.asList(new StringTextComponent(LocalStrings.Sort.getLocal()));
            GuiUtils.drawHoveringText((MatrixStack)p_onTooltip_2_, text, (int)p_onTooltip_3_, (int)p_onTooltip_4_, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }));
    }

    BagContainer getBagContainer() {
        return (BagContainer)this.field_147002_h;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.drawDefaultBackground(stack, partialTicks, mouseX, mouseY);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        int xOffset = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yOffset = (this.field_230709_l_ - this.field_147000_g) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BAG_GUI_TEXTURE);
        this.func_238474_b_(stack, xOffset, yOffset, 0, 0, this.field_146999_f, this.field_147000_g);
        if (specialFontRenderer == null) {
            specialFontRenderer = new GuiBagFontRenderer(this.field_230712_o_, (Integer)ChiselsAndBits.getConfig().getServer().bagStackSize.get());
        }
        this.hoveredBitSlot = null;
        for (int slotIdx = 0; slotIdx < this.getBagContainer().customSlots.size(); ++slotIdx) {
            Slot slot = this.getBagContainer().customSlots.get(slotIdx);
            FontRenderer defaultFontRenderer = this.field_230712_o_;
            try {
                this.field_230712_o_ = specialFontRenderer;
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
                this.func_238746_a_(stack, slot);
                RenderSystem.popMatrix();
            }
            finally {
                this.field_230712_o_ = defaultFontRenderer;
            }
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            int xDisplayPos = this.field_147003_i + slot.field_75223_e;
            int yDisplayPos = this.field_147009_r + slot.field_75221_f;
            this.hoveredBitSlot = slot;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int INNER_SLOT_SIZE = 16;
            this.func_238468_a_(stack, xDisplayPos, yDisplayPos, xDisplayPos + 16, yDisplayPos + 16, -2130706433, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
        if (!this.trashBtn.func_231047_b_(mouseX, mouseY)) {
            this.requireConfirm = true;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean duplicateButton = button == Minecraft.func_71410_x().field_71474_y.field_74322_I.getKey().func_197937_c() + 100;
        Slot slot = this.getSlotUnderMouse();
        if (slot == null) {
            slot = this.hoveredBitSlot;
        }
        if (slot != null && slot.field_75224_c instanceof TargetedInventory) {
            PacketBagGui bagGuiPacket = new PacketBagGui(slot.field_75222_d, button, duplicateButton, ClientSide.instance.holdingShift());
            bagGuiPacket.doAction(ClientSide.instance.getPlayer());
            ChiselsAndBits.getNetworkChannel().sendToServer(bagGuiPacket);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private ItemStack getInHandItem() {
        return this.getBagContainer().thePlayer.field_71071_by.func_70445_o();
    }

    private boolean isValidBitItem() {
        return ModUtil.isEmpty(this.getInHandItem()) || this.getInHandItem().func_77973_b() == ModItems.ITEM_BLOCK_BIT.get();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238407_a_(matrixStack, LanguageMap.func_74808_a().func_241870_a((ITextProperties)((ItemBitBag)ModItems.ITEM_BIT_BAG_DEFAULT.get()).func_200295_i(ModUtil.getEmptyStack())), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 93), 0x404040);
    }

    protected void drawDefaultBackground(MatrixStack matrixStack, float partialTicks, int x, int y) {
    }
}

