/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.Expandable;
import me.shedaniel.clothconfig2.forge.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SubCategoryListEntry
extends TooltipListEntry<List<AbstractConfigListEntry>>
implements Expandable {
    private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private List<AbstractConfigListEntry> entries;
    private CategoryLabelWidget widget;
    private List<IGuiEventListener> children;
    private boolean expanded;

    @Deprecated
    public SubCategoryListEntry(ITextComponent categoryName, List<AbstractConfigListEntry> entries, boolean defaultExpanded) {
        super(categoryName, null);
        this.entries = entries;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new IGuiEventListener[]{this.widget});
        this.children.addAll(entries);
        this.setReferenceProviderEntries(entries);
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isRequiresRestart() {
        for (AbstractConfigListEntry entry : this.entries) {
            if (!entry.isRequiresRestart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    public ITextComponent getCategoryName() {
        return this.getFieldName();
    }

    @Override
    public List<AbstractConfigListEntry> getValue() {
        return this.entries;
    }

    @Override
    public Optional<List<AbstractConfigListEntry>> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        ((CategoryLabelWidget)this.widget).rectangle.x = x - 19;
        ((CategoryLabelWidget)this.widget).rectangle.y = y;
        ((CategoryLabelWidget)this.widget).rectangle.width = entryWidth + 19;
        ((CategoryLabelWidget)this.widget).rectangle.height = 24;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CONFIG_TEX);
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matrices, x - 15, y + 4, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.getDisplayedFieldName().func_241878_f(), (float)x, (float)(y + 5), this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (AbstractConfigListEntry entry : this.entries) {
            entry.setParent(this.getParent());
            entry.setScreen(this.getConfigScreen());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (AbstractConfigListEntry entry : this.entries) {
                entry.render(matrices, -1, yy, x + 14, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered && this.func_241217_q_() == entry, delta);
                yy += entry.getItemHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (AbstractConfigListEntry entry : this.entries) {
            entry.updateSelected(this.expanded && isSelected && this.func_241217_q_() == entry);
        }
    }

    @Override
    public boolean isEdited() {
        for (AbstractConfigListEntry entry : this.entries) {
            if (!entry.isEdited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lateRender(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.expanded) {
            for (AbstractConfigListEntry entry : this.entries) {
                entry.lateRender(matrices, mouseX, mouseY, delta);
            }
        }
    }

    @Override
    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (AbstractConfigListEntry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    @Override
    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        ((CategoryLabelWidget)this.widget).rectangle.x = x - 15;
        ((CategoryLabelWidget)this.widget).rectangle.y = y;
        ((CategoryLabelWidget)this.widget).rectangle.width = entryWidth + 15;
        ((CategoryLabelWidget)this.widget).rectangle.height = 24;
        return this.widget.rectangle.contains(mouseX, mouseY) && this.getParent().func_231047_b_(mouseX, mouseY);
    }

    @Override
    public int getItemHeight() {
        if (this.expanded) {
            int i = 24;
            for (AbstractConfigListEntry entry : this.entries) {
                i += entry.getItemHeight();
            }
            return i;
        }
        return 24;
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public void save() {
        this.entries.forEach(AbstractConfigEntry::save);
    }

    @Override
    public Optional<ITextComponent> getError() {
        Object error = null;
        for (AbstractConfigListEntry entry : this.entries) {
            Optional<ITextComponent> configError = entry.getConfigError();
            if (!configError.isPresent()) continue;
            if (error != null) {
                return Optional.ofNullable(new TranslationTextComponent("text.cloth-config.multi_error"));
            }
            return configError;
        }
        return Optional.ofNullable(error);
    }

    public class CategoryLabelWidget
    implements IGuiEventListener {
        private Rectangle rectangle = new Rectangle();

        public boolean func_231044_a_(double double_1, double double_2, int int_1) {
            if (this.rectangle.contains(double_1, double_2)) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

