/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.api;

import me.shedaniel.clothconfig2.forge.api.Modifier;
import me.shedaniel.clothconfig2.forge.impl.ModifierKeyCodeImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public interface ModifierKeyCode {
    public static ModifierKeyCode of(InputMappings.Input keyCode, Modifier modifier) {
        return new ModifierKeyCodeImpl().setKeyCodeAndModifier(keyCode, modifier);
    }

    public static ModifierKeyCode copyOf(ModifierKeyCode code) {
        return ModifierKeyCode.of(code.getKeyCode(), code.getModifier());
    }

    public static ModifierKeyCode unknown() {
        return ModifierKeyCode.of(InputMappings.field_197958_a, Modifier.none());
    }

    public InputMappings.Input getKeyCode();

    public ModifierKeyCode setKeyCode(InputMappings.Input var1);

    default public InputMappings.Type getType() {
        return this.getKeyCode().func_197938_b();
    }

    public Modifier getModifier();

    public ModifierKeyCode setModifier(Modifier var1);

    default public ModifierKeyCode copy() {
        return ModifierKeyCode.copyOf(this);
    }

    default public boolean matchesMouse(int button) {
        return !this.isUnknown() && this.getType() == InputMappings.Type.MOUSE && this.getKeyCode().func_197937_c() == button && this.getModifier().matchesCurrent();
    }

    default public boolean matchesKey(int keyCode, int scanCode) {
        if (this.isUnknown()) {
            return false;
        }
        if (keyCode == InputMappings.field_197958_a.func_197937_c()) {
            return this.getType() == InputMappings.Type.SCANCODE && this.getKeyCode().func_197937_c() == scanCode && this.getModifier().matchesCurrent();
        }
        return this.getType() == InputMappings.Type.KEYSYM && this.getKeyCode().func_197937_c() == keyCode && this.getModifier().matchesCurrent();
    }

    default public boolean matchesCurrentMouse() {
        if (!this.isUnknown() && this.getType() == InputMappings.Type.MOUSE && this.getModifier().matchesCurrent()) {
            return GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)this.getKeyCode().func_197937_c()) == 1;
        }
        return false;
    }

    default public boolean matchesCurrentKey() {
        return !this.isUnknown() && this.getType() == InputMappings.Type.KEYSYM && this.getModifier().matchesCurrent() && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)this.getKeyCode().func_197937_c());
    }

    default public ModifierKeyCode setKeyCodeAndModifier(InputMappings.Input keyCode, Modifier modifier) {
        this.setKeyCode(keyCode);
        this.setModifier(modifier);
        return this;
    }

    default public ModifierKeyCode clearModifier() {
        return this.setModifier(Modifier.none());
    }

    public String toString();

    public ITextComponent getLocalizedName();

    default public boolean isUnknown() {
        return this.getKeyCode().equals((Object)InputMappings.field_197958_a);
    }
}

