/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.data;

import com.flanks255.simplylight.SLBlockReg;
import com.flanks255.simplylight.SLBlocks;
import com.flanks255.simplylight.blocks.BaseBlockItem;
import com.flanks255.simplylight.blocks.LampBlock;
import com.flanks255.simplylight.blocks.RodLamp;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "simplylight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateLampBlock();
        this.generateColorModels();
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_RED_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_RED);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GREEN_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GREEN);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLUE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLUE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_YELLOW_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_YELLOW);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_ORANGE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_ORANGE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PINK_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PINK);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIME_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIME);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_CYAN_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_CYAN);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PURPLE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_PURPLE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_MAGENTA_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_MAGENTA);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_GRAY_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_GRAY);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GRAY_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_GRAY);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_BLUE_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_LIGHT_BLUE);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BROWN_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BROWN);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLACK_ON);
        this.generateLampBlock(SLBlocks.ILLUMINANT_BLOCK_BLACK);
        this.generateThinLamps();
        this.myDirectionalBlock(SLBlocks.LIGHTBULB.get(), $ -> this.models().getExistingFile(this.modLoc("block/lightbulb")), 180);
        this.generateRodLamp();
        this.generateWallLamp();
    }

    private void generateWallLamp() {
        ModelFile.ExistingModelFile wallModel = this.models().getExistingFile(this.modLoc("block/wall_lamp"));
        ModelFile.ExistingModelFile floorModel = this.models().getExistingFile(this.modLoc("block/floorlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(SLBlocks.WALL_LAMP.get()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)floorModel).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)floorModel).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)wallModel).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)wallModel).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)wallModel).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)wallModel).rotationY(180).addModel();
    }

    private void generateThinLamps() {
        this.myDirectionalBlock(SLBlocks.ILLUMINANTSLAB.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_slab")), 180);
        this.myDirectionalBlock(SLBlocks.ILLUMINANTPANEL.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_panel")), 180);
    }

    void generateRodLamp() {
        RodLamp block = SLBlocks.RODLAMP.get();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/rodlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
    }

    private void generateLampBlock() {
        ResourceLocation offTex = this.modLoc("block/illuminant_block");
        ResourceLocation onTex = this.modLoc("block/illuminant_block_on");
        ModelBuilder.ElementBuilder illuminantBlockBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SLBlocks.ILLUMINANTBLOCK.get().getRegistryName().func_110623_a(), "cube")).texture("all", offTex)).texture("particle", offTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock = illuminantBlockBuilder.cube("#all").shade(false).end();
        ModelBuilder.ElementBuilder illuminantBlockBuilder_On = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SLBlocks.ILLUMINANTBLOCK_ON.get().getRegistryName().func_110623_a(), "cube")).texture("all", onTex)).texture("particle", onTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock_on = illuminantBlockBuilder_On.cube("#all").shade(false).end();
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder(SLBlocks.ILLUMINANTBLOCK.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
        VariantBlockStateBuilder LampBlockOnBuilder = this.getVariantBuilder(SLBlocks.ILLUMINANTBLOCK_ON.get());
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
    }

    private void generateColorModels() {
        for (DyeColor color : DyeColor.values()) {
            if (color == DyeColor.WHITE) continue;
            ResourceLocation tex = this.modLoc("block/full_block/illuminant_" + color.func_176762_d() + "_block");
            ResourceLocation tex_on = this.modLoc("block/full_block/illuminant_" + color.func_176762_d() + "_block_on");
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_" + color.func_176762_d() + "_block", this.modLoc("block/illuminant_block"))).texture("all", tex)).texture("particle", tex);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/illuminant_" + color.func_176762_d() + "_block_on", this.modLoc("block/illuminant_block"))).texture("all", tex_on)).texture("particle", tex_on);
        }
    }

    private void generateLampBlock(SLBlockReg<LampBlock, BaseBlockItem> block) {
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder(block.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/illuminant_" + block.getBlock().color.func_176762_d() + "_block_on"))).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/illuminant_" + block.getBlock().color.func_176762_d() + "_block"))).addModel();
    }

    public void myDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + angleOffset) % 360).build();
        }, new Property[]{BlockStateProperties.field_208198_y});
    }
}

