/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.part;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.part.PartTypeTerminal;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class PartTypeTerminalStorage
extends PartTypeTerminal<PartTypeTerminalStorage, State> {
    public PartTypeTerminalStorage(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.terminalStorageBaseConsumption;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public Optional<INamedContainerProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(PartTypeTerminalStorage.this.getTranslationKey());
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                State state = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                TerminalStorageState terminalStorageState = state.getPlayerStorageState(playerEntity);
                return new ContainerTerminalStoragePart(id, playerInventory, (PartTarget)data.getRight(), (PartTypeTerminalStorage)((Object)data.getMiddle()), Optional.empty(), terminalStorageState);
            }
        });
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
        PacketCodec.write((PacketBuffer)packetBuffer, (Object)pos);
        super.writeExtraGuiData(packetBuffer, pos, player);
        packetBuffer.writeBoolean(false);
        State state = (State)PartHelpers.getPartContainerChecked((PartPos)pos).getPartState(pos.getSide());
        TerminalStorageState terminalStorageState = state.getPlayerStorageState((PlayerEntity)player);
        terminalStorageState.writeToPacketBuffer(packetBuffer);
    }

    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (Map.Entry<String, NonNullList<ItemStack>> entry : state.getNamedInventories().entrySet()) {
            if (entry.getKey().equals(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
                entry.getValue().set(0, (Object)ItemStack.field_190927_a);
            }
            for (ItemStack itemStack : entry.getValue()) {
                if (itemStack.func_190926_b()) continue;
                itemStacks.add(itemStack);
            }
        }
        state.clearNamedInventories();
        super.addDrops(target, (IPartState)state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartStateEmpty<PartTypeTerminalStorage>
    implements ITerminalStorageTabCommon.IVariableInventory {
        private final Map<String, NonNullList<ItemStack>> namedInventories = Maps.newHashMap();
        private final Map<String, TerminalStorageState> playerStorageStates = Maps.newHashMap();

        public int getUpdateInterval() {
            return 1;
        }

        public void clearNamedInventories() {
            this.namedInventories.clear();
        }

        @Override
        public void setNamedInventory(String name, NonNullList<ItemStack> inventory) {
            this.namedInventories.put(name, inventory);
            this.onDirty();
        }

        public Map<String, NonNullList<ItemStack>> getNamedInventories() {
            return this.namedInventories;
        }

        @Override
        @Nullable
        public NonNullList<ItemStack> getNamedInventory(String name) {
            return this.namedInventories.get(name);
        }

        public TerminalStorageState getPlayerStorageState(PlayerEntity player) {
            TerminalStorageState state = this.playerStorageStates.get(player.func_110124_au().toString());
            if (state == null) {
                state = TerminalStorageState.getPlayerDefault(player, (IDirtyMarkListener)this);
                this.playerStorageStates.put(player.func_110124_au().toString(), state);
                this.onDirty();
            }
            return state;
        }

        public void writeToNBT(CompoundNBT tag) {
            super.writeToNBT(tag);
            ListNBT namedInventoriesList = new ListNBT();
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.namedInventories.entrySet()) {
                CompoundNBT listEntry = new CompoundNBT();
                listEntry.func_74778_a("tabName", entry.getKey());
                listEntry.func_74768_a("itemCount", entry.getValue().size());
                ItemStackHelper.func_191282_a((CompoundNBT)listEntry, entry.getValue());
                namedInventoriesList.add((Object)listEntry);
            }
            tag.func_218657_a("namedInventories", (INBT)namedInventoriesList);
            ListNBT playerStorageStatesList = new ListNBT();
            for (Map.Entry<String, TerminalStorageState> entry : this.playerStorageStates.entrySet()) {
                CompoundNBT stateEntry = new CompoundNBT();
                stateEntry.func_74778_a("player", entry.getKey());
                stateEntry.func_218657_a("value", (INBT)entry.getValue().getTag());
                playerStorageStatesList.add((Object)stateEntry);
            }
            tag.func_218657_a("playerStorageStates", (INBT)playerStorageStatesList);
        }

        public void readFromNBT(CompoundNBT tag) {
            super.readFromNBT(tag);
            for (INBT listEntry : tag.func_150295_c("namedInventories", 10)) {
                NonNullList list = NonNullList.func_191197_a((int)((CompoundNBT)listEntry).func_74762_e("itemCount"), (Object)ItemStack.field_190927_a);
                String tabName = ((CompoundNBT)listEntry).func_74779_i("tabName");
                ItemStackHelper.func_191283_b((CompoundNBT)((CompoundNBT)listEntry), (NonNullList)list);
                this.namedInventories.put(tabName, (NonNullList<ItemStack>)list);
            }
            for (INBT listEntry : tag.func_150295_c("playerStorageStates", 10)) {
                String playerName = ((CompoundNBT)listEntry).func_74779_i("player");
                TerminalStorageState state = new TerminalStorageState(((CompoundNBT)listEntry).func_74775_l("value"), (IDirtyMarkListener)this);
                this.playerStorageStates.put(playerName, state);
            }
        }
    }
}

