/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackQuantitySorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerFluidStack
implements IIngredientComponentTerminalStorageHandler<FluidStack, Integer> {
    private final IngredientComponent<FluidStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerFluidStack(IngredientComponent<FluidStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<FluidStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)Items.field_151131_as);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(MatrixStack matrixStack, FluidStack instance, long maxQuantity, @Nullable String label, ContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<ITextComponent> additionalTooltipLines) {
        if (instance != null) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                GuiHelpers.renderFluidSlot((AbstractGui)gui, (MatrixStack)matrixStack, (FluidStack)instance, (int)x, (int)y);
                RenderItemExtendedSlotCount.getInstance().drawSlotText(Minecraft.func_71410_x().field_71466_p, new MatrixStack(), label != null ? label : GuiHelpers.quantityToScaledString((long)instance.getAmount()), x, y);
                GlStateManager.func_227722_g_();
            } else {
                GuiHelpers.renderTooltip((ContainerScreen)gui, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(((IFormattableTextComponent)instance.getDisplayName()).func_240699_a_(instance.getFluid().getAttributes().getRarity().field_77937_e));
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(FluidStack instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.fluid.amount", (Object[])new Object[]{String.format(Locale.ROOT, "%,d", FluidHelpers.getAmount((FluidStack)instance))});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @Override
    public FluidStack getInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0) : FluidStack.EMPTY).orElse(FluidStack.EMPTY);
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getTankCapacity(0) : 0).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<FluidStack, Integer> storage, FluidStack maxInstance, PlayerEntity player) {
        return 0;
    }

    @Override
    public FluidStack insertIntoContainer(IIngredientComponentStorage<FluidStack, Integer> storage, Container container, int containerSlot, FluidStack maxInstance, @Nullable PlayerEntity player, boolean transferFullSelection) {
        ItemStack stack = container.func_75139_a(containerSlot).func_75211_c();
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            FluidStack moved = FluidStack.EMPTY;
            try {
                moved = (FluidStack)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (Object)maxInstance, (Object)this.ingredientComponent.getMatcher().getExactMatchNoQuantityCondition(), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.func_75139_a(containerSlot).func_75215_d(fluidHandler.getContainer());
            container.func_75142_b();
            return moved;
        }).orElse(FluidStack.EMPTY);
    }

    protected IIngredientComponentStorage<FluidStack, Integer> getFluidStorage(IngredientComponent<FluidStack, Integer> component, IFluidHandlerItem fluidHandler) {
        return component.getStorageWrapperHandler(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).wrapComponentStorage((Object)fluidHandler);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<FluidStack, Integer> storage, PlayerInventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = playerInventory.func_70445_o();
        playerStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            playerInventory.func_70437_b(fluidHandler.getContainer());
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<FluidStack, Integer> storage, Container container, int containerSlot, PlayerInventory playerInventory, int limit) {
        ItemStack toMoveStack = container.func_75139_a(containerSlot).func_75211_c();
        toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.func_75139_a(containerSlot).func_75215_d(fluidHandler.getContainer());
            container.func_75142_b();
        });
    }

    @Override
    public long getActivePlayerStackQuantity(PlayerInventory playerInventory) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        return toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0).getAmount() : 0).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(PlayerInventory playerInventory, long quantityIn) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = fluidHandler.drain((int)quantity, IFluidHandler.FluidAction.EXECUTE).getAmount()) > 0; quantity -= (long)drained) {
            }
            playerInventory.func_70437_b(fluidHandler.getContainer());
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<FluidStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        switch (searchMode) {
            case MOD: {
                return i -> i.getFluid().getRegistryName().func_110624_b().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            }
            case TOOLTIP: {
                return i -> false;
            }
            case TAG: {
                return i -> FluidTags.func_226157_a_().func_199913_a((Object)i.getFluid()).stream().filter(id -> id.toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).map(r -> FluidTags.func_226157_a_().func_199910_a(r)).anyMatch(Objects::nonNull);
            }
            case DEFAULT: {
                return i -> i != null && i.getDisplayName().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            }
        }
        return null;
    }

    @Override
    public Collection<IIngredientInstanceSorter<FluidStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new FluidStackNameSorter(), new FluidStackIdSorter(), new FluidStackQuantitySorter()});
    }
}

