/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.util.inventory;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class ItemUtils {
    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchNBT) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        return !matchNBT || ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack == ItemStack.field_190927_a || stack == null || stack.func_190916_E() <= 0;
    }

    public static int getSize(ItemStack stack) {
        return ItemUtils.isEmpty(stack) ? 0 : stack.func_190916_E();
    }

    public static ItemStack setSize(ItemStack stack, int size) {
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack increaseSize(ItemStack stack, int amount) {
        return ItemUtils.setSize(stack, ItemUtils.getSize(stack) + amount);
    }

    public static ItemStack increaseSize(ItemStack stack) {
        return ItemUtils.increaseSize(stack, 1);
    }

    public static ItemStack decreaseSize(ItemStack stack, int amount) {
        return ItemUtils.setSize(stack, ItemUtils.getSize(stack) - amount);
    }

    public static ItemStack decreaseSize(ItemStack stack) {
        return ItemUtils.decreaseSize(stack, 1);
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        if (ItemUtils.isEmpty(stack)) {
            return ItemStack.field_190927_a;
        }
        return ItemUtils.setSize(stack.func_77946_l(), size);
    }

    public static void dropInventory(World world, ItemStackHandler inventory, BlockPos pos, boolean motion, int pickupDelay) {
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemUtils.dropItem(inventory.getStackInSlot(slot), world, pos, motion, pickupDelay);
        }
    }

    public static void dropItem(ItemStack stack, World world, BlockPos pos, boolean motion, int pickupDelay) {
        if (world.field_72995_K) {
            return;
        }
        if (stack.func_77976_d() <= 0 || stack.func_190926_b()) {
            return;
        }
        ItemEntity entityitem = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        entityitem.func_174867_a(pickupDelay);
        if (!motion) {
            entityitem.func_213293_j(0.0, 0.0, 0.0);
        }
        world.func_217376_c((Entity)entityitem);
    }
}

