/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.items;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.client.CreativeTabQuantumStorage;
import net.gigabit101.quantumstorage.items.CustomEnergyStorage;
import net.gigabit101.quantumstorage.items.RfUtils;
import net.gigabit101.quantumstorage.items.prefab.ItemBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemQuantumBattery
extends ItemBase {
    private static final IEnergyStorage EMPTY_ENERGY_STORAGE = new EnergyStorage(Integer.MAX_VALUE);

    public ItemQuantumBattery() {
        super(new Item.Properties().func_208103_a(Rarity.EPIC).func_200917_a(1).func_200916_a((ItemGroup)CreativeTabQuantumStorage.INSTANCE));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        this.getEnergyStorage(playerIn.func_184586_b(handIn)).receiveEnergy(666666666, false);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int p_77663_4_, boolean isSelected) {
        if (entity instanceof PlayerEntity && !isSelected) {
            PlayerEntity player = (PlayerEntity)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (this.getEnergyStorage(stack).getEnergyStored() <= 0) continue;
                AtomicBoolean charging = new AtomicBoolean(false);
                slot.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                    if (energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored()) {
                        charging.set(true);
                        int insert = Math.min(1000, this.getEnergyStorage(stack).getEnergyStored());
                        insert = energyStorage.receiveEnergy(insert, false);
                        this.getEnergyStorage(stack).extractEnergy(insert, false);
                    }
                });
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(RfUtils.addPowerTooltip(this.getEnergyStorage(stack))));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double max = this.getEnergyStorage(stack).getMaxEnergyStored();
        double diff = max - (double)this.getEnergyStorage(stack).getEnergyStored();
        return diff / max;
    }

    public IEnergyStorage getEnergyStorage(ItemStack stack) {
        if (CapabilityEnergy.ENERGY == null) {
            return EMPTY_ENERGY_STORAGE;
        }
        return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse((Object)EMPTY_ENERGY_STORAGE);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyCapabilityProvider(stack, this);
    }

    public static class EnergyCapabilityProvider
    implements ICapabilityProvider {
        public final CustomEnergyStorage storage;

        public EnergyCapabilityProvider(final ItemStack stack, ItemQuantumBattery item) {
            this.storage = new CustomEnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE){

                public int getEnergyStored() {
                    if (stack.func_77942_o()) {
                        return stack.func_77978_p().func_74762_e("Energy");
                    }
                    return 0;
                }

                @Override
                public void setEnergyStored(int energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new CompoundNBT());
                    }
                    stack.func_77978_p().func_74768_a("Energy", energy);
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            if (capability == CapabilityEnergy.ENERGY) {
                return LazyOptional.of(() -> this.storage).cast();
            }
            return LazyOptional.empty();
        }
    }
}

