/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;
import wayoftime.bloodmagic.common.item.inventory.ContainerTrainingBracelet;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.network.LivingTrainerPacket;
import wayoftime.bloodmagic.network.LivingTrainerWhitelistPacket;

public class ScreenTrainingBracelet
extends ScreenBase<ContainerTrainingBracelet> {
    private static final ResourceLocation background = BloodMagic.rl("textures/gui/trainingbracelet.png");
    public IInventory trainerInventory;
    private PlayerEntity player;
    private int left;
    private int top;
    private List<String> buttonKeyList = new ArrayList<String>();
    private int whitelistButtonPosX = 24;
    private int whitelistButtonPosY = 55;
    private int numberHoverPosX = 16;
    private int numberHoverPosY = 34;
    private int numberHoverWidth = 36;
    private int numberHoverHeight = 20;
    protected boolean isWhitelist = false;

    public ScreenTrainingBracelet(ContainerTrainingBracelet container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.trainerInventory = container.inventoryTrainer;
        this.field_146999_f = 176;
        this.field_147000_g = 187;
        this.player = playerInventory.field_70458_d;
        this.isWhitelist = ((ItemLivingTrainer)container.trainerStack.func_77973_b()).getIsWhitelist(container.trainerStack);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.left = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.top = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.buttonKeyList.clear();
        ItemStack filterStack = ((ContainerTrainingBracelet)this.field_147002_h).trainerStack;
        this.func_230480_a_((Widget)new Button(this.left + 62 - 18, this.top + 34, 8, 20, (ITextComponent)new StringTextComponent(">"), (Button.IPressable)new IncrementPress(this, 0)));
        this.func_230480_a_((Widget)new Button(this.left + 34 - 18, this.top + 34, 8, 20, (ITextComponent)new StringTextComponent("<"), (Button.IPressable)new IncrementPress(this, 1)));
        this.func_230480_a_((Widget)new Button(this.left + this.whitelistButtonPosX, this.top + this.whitelistButtonPosY, 20, 20, (ITextComponent)new StringTextComponent(""), (Button.IPressable)new WhitelistTogglePress(this)));
    }

    private int getCurrentActiveSlotUpgradeLevel() {
        if (((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked == -1) {
            return 0;
        }
        ItemStack stack = ((ContainerTrainingBracelet)this.field_147002_h).func_75139_a(((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked).func_75211_c();
        return this.getStackUpgradeLevel(stack);
    }

    private int setCurrentActiveSlotUpgradeLevel(int level) {
        LivingStats stats;
        if (((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked == -1) {
            return 0;
        }
        int slotClicked = ((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked;
        ItemStack stack = ((ContainerTrainingBracelet)this.field_147002_h).func_75139_a(slotClicked).func_75211_c();
        level = Math.max(0, Math.min(level, this.getMaxUpgradeLevel(stack)));
        if (stack.func_77973_b() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.func_77973_b()).getLivingStats(stack)) != null) {
            LivingStats newStats = new LivingStats();
            for (Map.Entry<LivingUpgrade, Double> entry : stats.getUpgrades().entrySet()) {
                double exp = level == 0 ? 0.01 : (double)entry.getKey().getLevelExp(level);
                newStats.addExperience(entry.getKey().getKey(), exp);
            }
            ((ILivingContainer)stack.func_77973_b()).updateLivingStats(stack, newStats);
            ((ContainerTrainingBracelet)this.field_147002_h).func_75139_a(slotClicked).func_75215_d(stack);
            ((ContainerTrainingBracelet)this.field_147002_h).inventoryTrainer.func_70299_a(slotClicked, stack);
            ((ItemLivingTrainer)((ContainerTrainingBracelet)this.field_147002_h).trainerStack.func_77973_b()).setTomeLevel(((ContainerTrainingBracelet)this.field_147002_h).trainerStack, slotClicked, level);
            return level;
        }
        return 0;
    }

    private int getStackUpgradeLevel(ItemStack stack) {
        Iterator<Map.Entry<LivingUpgrade, Double>> iterator;
        LivingStats stats;
        if (stack.func_77973_b() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.func_77973_b()).getLivingStats(stack)) != null && (iterator = stats.getUpgrades().entrySet().iterator()).hasNext()) {
            Map.Entry<LivingUpgrade, Double> entry = iterator.next();
            return entry.getKey().getLevel(entry.getValue().intValue());
        }
        return 0;
    }

    private int getMaxUpgradeLevel(ItemStack stack) {
        Iterator<Map.Entry<LivingUpgrade, Double>> iterator;
        LivingStats stats;
        if (stack.func_77973_b() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.func_77973_b()).getLivingStats(stack)) != null && (iterator = stats.getUpgrades().entrySet().iterator()).hasNext()) {
            Map.Entry<LivingUpgrade, Double> entry = iterator.next();
            return entry.getKey().getLevel(Integer.MAX_VALUE);
        }
        return 0;
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        String textEntry = "" + this.getCurrentActiveSlotUpgradeLevel();
        int offset = -3 * textEntry.length();
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new StringTextComponent(textEntry), (float)(27 + offset) + 7.5f, 40.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("container.inventory"), 8.0f, 93.0f, 0x404040);
        this.field_230712_o_.func_243248_b(stack, ((ContainerTrainingBracelet)this.field_147002_h).trainerStack.func_200301_q(), 8.0f, 4.0f, 0x404040);
        int w = 20;
        int h = 20;
        int xl = this.whitelistButtonPosX;
        int yl = this.whitelistButtonPosY;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(background);
        this.func_238474_b_(stack, xl, yl, 176, this.isWhitelist ? 0 : 20, w, h);
    }

    @Override
    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(background);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        ItemStack held = this.player.func_184586_b(Hand.MAIN_HAND);
        if (((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked >= 0) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(stack, 85 + x + 21 * (((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked % 4), y + 11 + 21 * (((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked / 4), 0, 187, 24, 24);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        List<ITextComponent> components;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        int w = 20;
        int h = 20;
        int x = this.field_147003_i + this.whitelistButtonPosX;
        int y = this.field_147009_r + this.whitelistButtonPosY;
        if (mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h && (components = this.getHoverTextForWhitelistButton()) != null && !components.isEmpty()) {
            tooltip.addAll(components);
        }
        w = this.numberHoverWidth;
        h = this.numberHoverHeight;
        x = this.field_147003_i + this.numberHoverPosX;
        y = this.field_147009_r + this.numberHoverPosY;
        if (mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h && (components = this.getHoverTextForNumber()) != null && !components.isEmpty()) {
            tooltip.addAll(components);
        }
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    private List<ITextComponent> getHoverTextForWhitelistButton() {
        ArrayList<ITextComponent> components = new ArrayList<ITextComponent>();
        if (this.isWhitelist) {
            components.add((ITextComponent)new TranslationTextComponent("trainer.bloodmagic.whitelist"));
        } else {
            components.add((ITextComponent)new TranslationTextComponent("trainer.bloodmagic.blacklist"));
        }
        return components;
    }

    private List<ITextComponent> getHoverTextForNumber() {
        LivingStats stats;
        ArrayList<ITextComponent> components = new ArrayList<ITextComponent>();
        if (((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked == -1) {
            return components;
        }
        int slotClicked = ((ContainerTrainingBracelet)this.field_147002_h).lastGhostSlotClicked;
        ItemStack stack = ((ContainerTrainingBracelet)this.field_147002_h).func_75139_a(slotClicked).func_75211_c();
        if (stack.func_77973_b() instanceof ILivingContainer && (stats = ((ILivingContainer)stack.func_77973_b()).getLivingStats(stack)) != null) {
            for (Map.Entry<LivingUpgrade, Double> entry : stats.getUpgrades().entrySet()) {
                int level = entry.getKey().getLevel(entry.getValue().intValue());
                if (level > 0) {
                    components.add((ITextComponent)new TranslationTextComponent("trainer.bloodmagic.allowupgrade", new Object[]{new TranslationTextComponent(entry.getKey().getTranslationKey()), new TranslationTextComponent("enchantment.level." + level)}));
                    continue;
                }
                components.add((ITextComponent)new TranslationTextComponent("trainer.bloodmagic.blockupgrade", new Object[]{new TranslationTextComponent(entry.getKey().getTranslationKey())}));
            }
        }
        return components;
    }

    public class IncrementPress
    implements Button.IPressable {
        private final ScreenTrainingBracelet screen;
        private final int id;

        public IncrementPress(ScreenTrainingBracelet screen, int id) {
            this.screen = screen;
            this.id = id;
        }

        public void onPress(Button button) {
            if (((ContainerTrainingBracelet)this.screen.field_147002_h).lastGhostSlotClicked == -1) {
                return;
            }
            if (this.id == 0) {
                int currentLevel = ScreenTrainingBracelet.this.getCurrentActiveSlotUpgradeLevel();
                int newLevel = ScreenTrainingBracelet.this.setCurrentActiveSlotUpgradeLevel(currentLevel + 1);
                BloodMagic.packetHandler.sendToServer(new LivingTrainerPacket(((ScreenTrainingBracelet)ScreenTrainingBracelet.this).player.field_71071_by.field_70461_c, ((ContainerTrainingBracelet)this.screen.field_147002_h).lastGhostSlotClicked, newLevel));
            } else if (this.id == 1) {
                int currentLevel = ScreenTrainingBracelet.this.getCurrentActiveSlotUpgradeLevel();
                int newLevel = ScreenTrainingBracelet.this.setCurrentActiveSlotUpgradeLevel(currentLevel - 1);
                BloodMagic.packetHandler.sendToServer(new LivingTrainerPacket(((ScreenTrainingBracelet)ScreenTrainingBracelet.this).player.field_71071_by.field_70461_c, ((ContainerTrainingBracelet)this.screen.field_147002_h).lastGhostSlotClicked, newLevel));
            }
        }
    }

    public class WhitelistTogglePress
    implements Button.IPressable {
        private final ScreenTrainingBracelet screen;

        public WhitelistTogglePress(ScreenTrainingBracelet screen) {
            this.screen = screen;
        }

        public void onPress(Button button) {
            boolean newWhitelistState;
            this.screen.isWhitelist = newWhitelistState = !this.screen.isWhitelist;
            ((ItemLivingTrainer)((ContainerTrainingBracelet)this.screen.field_147002_h).trainerStack.func_77973_b()).setIsWhitelist(((ContainerTrainingBracelet)this.screen.field_147002_h).trainerStack, newWhitelistState);
            BloodMagic.packetHandler.sendToServer(new LivingTrainerWhitelistPacket(((ScreenTrainingBracelet)ScreenTrainingBracelet.this).player.field_71071_by.field_70461_c, newWhitelistState));
        }
    }
}

