/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.lib.client.audio.ConditionalSound;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermal.core.util.managers.machine.FurnaceRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.init.TExpSounds;
import cofh.thermal.expansion.inventory.container.machine.MachineFurnaceContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;

public class MachineFurnaceTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && FurnaceRecipeManager.instance().validRecipe(item));
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();

    public MachineFurnaceTile() {
        super(TExpReferences.MACHINE_FURNACE_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = FurnaceRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineFurnaceContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSound(TExpSounds.SOUND_MACHINE_FURNACE, SoundCategory.AMBIENT, (TileEntity)this, () -> !this.field_145846_f && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }

    protected boolean validateOutputs() {
        if (this.curRecipe == null && !this.cacheRecipe()) {
            return false;
        }
        ItemStack output = this.outputSlot.getItemStack();
        if (output.func_190926_b()) {
            return true;
        }
        ItemStack recipeOutput = (ItemStack)this.curRecipe.getOutputItems((IMachineInventory)this).get(0);
        if (output.func_190916_E() >= output.func_77976_d()) {
            return false;
        }
        return ItemHelper.itemsEqualWithTags((ItemStack)output, (ItemStack)recipeOutput);
    }
}

